/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.update;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.LongSupplier;
import org.apache.flink.elasticsearch6.shaded.org.apache.logging.log4j.Logger;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.ElasticsearchException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.DocWriteResponse;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.delete.DeleteRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.index.IndexRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.update.UpdateRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.update.UpdateResponse;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.Requests;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.bytes.BytesReference;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.collect.Tuple;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.component.AbstractComponent;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.document.DocumentField;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.Streamable;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentHelper;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentType;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.VersionType;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.engine.DocumentMissingException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.engine.DocumentSourceMissingException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.get.GetResult;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.shard.IndexShard;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.shard.ShardId;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.script.ExecutableScript;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.script.Script;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.script.ScriptService;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.lookup.SourceLookup;

public class UpdateHelper
extends AbstractComponent {
    private final ScriptService scriptService;

    public UpdateHelper(Settings settings, ScriptService scriptService) {
        super(settings);
        this.scriptService = scriptService;
    }

    public Result prepare(UpdateRequest request, IndexShard indexShard, LongSupplier nowInMillis) {
        GetResult getResult = indexShard.getService().getForUpdate(request.type(), request.id(), request.version(), request.versionType());
        return this.prepare(indexShard.shardId(), request, getResult, nowInMillis);
    }

    protected Result prepare(ShardId shardId, UpdateRequest request, GetResult getResult, LongSupplier nowInMillis) {
        if (!getResult.isExists()) {
            return this.prepareUpsert(shardId, request, getResult, nowInMillis);
        }
        if (getResult.internalSourceRef() == null) {
            throw new DocumentSourceMissingException(shardId, request.type(), request.id());
        }
        if (request.script() == null && request.doc() != null) {
            return this.prepareUpdateIndexRequest(shardId, request, getResult, request.detectNoop());
        }
        return this.prepareUpdateScriptRequest(shardId, request, getResult, nowInMillis);
    }

    Tuple<UpdateOpType, Map<String, Object>> executeScriptedUpsert(IndexRequest upsert, Script script, LongSupplier nowInMillis) {
        Map<String, Object> upsertDoc = upsert.sourceAsMap();
        Map<String, Object> ctx = new HashMap<String, Object>(3);
        ctx.put("op", UpdateOpType.CREATE.toString());
        ctx.put("_source", upsertDoc);
        ctx.put("_now", nowInMillis.getAsLong());
        ctx = this.executeScript(script, ctx);
        UpdateOpType operation = UpdateOpType.lenientFromString((String)ctx.get("op"), this.logger, script.getIdOrCode());
        Map newSource = (Map)ctx.get("_source");
        if (operation != UpdateOpType.CREATE && operation != UpdateOpType.NONE) {
            this.logger.warn("Invalid upsert operation [{}] for script [{}], doing nothing...", (Object)operation, (Object)script.getIdOrCode());
            operation = UpdateOpType.NONE;
        }
        return new Tuple<UpdateOpType, Map<String, Object>>(operation, newSource);
    }

    Result prepareUpsert(ShardId shardId, UpdateRequest request, GetResult getResult, LongSupplier nowInMillis) {
        IndexRequest indexRequest;
        if (request.upsertRequest() == null && !request.docAsUpsert()) {
            throw new DocumentMissingException(shardId, request.type(), request.id());
        }
        IndexRequest indexRequest2 = indexRequest = request.docAsUpsert() ? request.doc() : request.upsertRequest();
        if (request.scriptedUpsert() && request.script() != null) {
            IndexRequest upsert = request.upsertRequest();
            Tuple<UpdateOpType, Map<String, Object>> upsertResult = this.executeScriptedUpsert(upsert, request.script, nowInMillis);
            switch (upsertResult.v1()) {
                case CREATE: {
                    indexRequest.source(upsertResult.v2());
                    break;
                }
                case NONE: {
                    UpdateResponse update = new UpdateResponse(shardId, getResult.getType(), getResult.getId(), getResult.getVersion(), DocWriteResponse.Result.NOOP);
                    update.setGetResult(getResult);
                    return new Result(update, DocWriteResponse.Result.NOOP, upsertResult.v2(), XContentType.JSON);
                }
                default: {
                    throw new IllegalArgumentException("unknown upsert operation, got: " + (Object)((Object)upsertResult.v1()));
                }
            }
        }
        ((IndexRequest)((IndexRequest)((IndexRequest)((IndexRequest)indexRequest.index(request.index())).type(request.type()).id(request.id()).setRefreshPolicy(request.getRefreshPolicy())).routing(request.routing()).parent(request.parent()).timeout(request.timeout())).waitForActiveShards(request.waitForActiveShards())).create(true);
        if (request.versionType() != VersionType.INTERNAL) {
            indexRequest.version(request.version()).versionType(request.versionType());
        }
        return new Result(indexRequest, DocWriteResponse.Result.CREATED, null, null);
    }

    static long calculateUpdateVersion(UpdateRequest request, GetResult getResult) {
        if (request.versionType() != VersionType.INTERNAL) {
            assert (request.versionType() == VersionType.FORCE);
            return request.version();
        }
        return getResult.getVersion();
    }

    @Nullable
    static String calculateRouting(GetResult getResult, @Nullable IndexRequest updateIndexRequest) {
        if (updateIndexRequest != null && updateIndexRequest.routing() != null) {
            return updateIndexRequest.routing();
        }
        if (getResult.getFields().containsKey("_routing")) {
            return getResult.field("_routing").getValue().toString();
        }
        return null;
    }

    @Nullable
    static String calculateParent(GetResult getResult, @Nullable IndexRequest updateIndexRequest) {
        if (updateIndexRequest != null && updateIndexRequest.parent() != null) {
            return updateIndexRequest.parent();
        }
        if (getResult.getFields().containsKey("_parent")) {
            return getResult.field("_parent").getValue().toString();
        }
        return null;
    }

    Result prepareUpdateIndexRequest(ShardId shardId, UpdateRequest request, GetResult getResult, boolean detectNoop) {
        boolean noop;
        long updateVersion = UpdateHelper.calculateUpdateVersion(request, getResult);
        IndexRequest currentRequest = request.doc();
        String routing = UpdateHelper.calculateRouting(getResult, currentRequest);
        String parent = UpdateHelper.calculateParent(getResult, currentRequest);
        Tuple<XContentType, Map<String, Object>> sourceAndContent = XContentHelper.convertToMap(getResult.internalSourceRef(), true);
        XContentType updateSourceContentType = sourceAndContent.v1();
        Map<String, Object> updatedSourceAsMap = sourceAndContent.v2();
        boolean bl = noop = !XContentHelper.update(updatedSourceAsMap, currentRequest.sourceAsMap(), detectNoop);
        if (detectNoop && noop) {
            UpdateResponse update = new UpdateResponse(shardId, getResult.getType(), getResult.getId(), getResult.getVersion(), DocWriteResponse.Result.NOOP);
            update.setGetResult(UpdateHelper.extractGetResult(request, request.index(), getResult.getVersion(), updatedSourceAsMap, updateSourceContentType, getResult.internalSourceRef()));
            return new Result(update, DocWriteResponse.Result.NOOP, updatedSourceAsMap, updateSourceContentType);
        }
        IndexRequest finalIndexRequest = (IndexRequest)((IndexRequest)((IndexRequest)Requests.indexRequest(request.index()).type(request.type()).id(request.id()).routing(routing).parent(parent).source(updatedSourceAsMap, updateSourceContentType).version(updateVersion).versionType(request.versionType()).waitForActiveShards(request.waitForActiveShards())).timeout(request.timeout())).setRefreshPolicy(request.getRefreshPolicy());
        return new Result(finalIndexRequest, DocWriteResponse.Result.UPDATED, updatedSourceAsMap, updateSourceContentType);
    }

    Result prepareUpdateScriptRequest(ShardId shardId, UpdateRequest request, GetResult getResult, LongSupplier nowInMillis) {
        long updateVersion = UpdateHelper.calculateUpdateVersion(request, getResult);
        IndexRequest currentRequest = request.doc();
        String routing = UpdateHelper.calculateRouting(getResult, currentRequest);
        String parent = UpdateHelper.calculateParent(getResult, currentRequest);
        Tuple<XContentType, Map<String, Object>> sourceAndContent = XContentHelper.convertToMap(getResult.internalSourceRef(), true);
        XContentType updateSourceContentType = sourceAndContent.v1();
        Map<String, Object> sourceAsMap = sourceAndContent.v2();
        Map<String, Object> ctx = new HashMap<String, Object>(16);
        ctx.put("op", UpdateOpType.INDEX.toString());
        ctx.put("_index", getResult.getIndex());
        ctx.put("_type", getResult.getType());
        ctx.put("_id", getResult.getId());
        ctx.put("_version", getResult.getVersion());
        ctx.put("_routing", routing);
        ctx.put("_parent", parent);
        ctx.put("_source", sourceAsMap);
        ctx.put("_now", nowInMillis.getAsLong());
        ctx = this.executeScript(request.script, ctx);
        UpdateOpType operation = UpdateOpType.lenientFromString((String)ctx.get("op"), this.logger, request.script.getIdOrCode());
        Map updatedSourceAsMap = (Map)ctx.get("_source");
        switch (operation) {
            case INDEX: {
                IndexRequest indexRequest = (IndexRequest)((IndexRequest)((IndexRequest)Requests.indexRequest(request.index()).type(request.type()).id(request.id()).routing(routing).parent(parent).source(updatedSourceAsMap, updateSourceContentType).version(updateVersion).versionType(request.versionType()).waitForActiveShards(request.waitForActiveShards())).timeout(request.timeout())).setRefreshPolicy(request.getRefreshPolicy());
                return new Result(indexRequest, DocWriteResponse.Result.UPDATED, updatedSourceAsMap, updateSourceContentType);
            }
            case DELETE: {
                DeleteRequest deleteRequest = (DeleteRequest)((DeleteRequest)((DeleteRequest)Requests.deleteRequest(request.index()).type(request.type()).id(request.id()).routing(routing).parent(parent).version(updateVersion).versionType(request.versionType()).waitForActiveShards(request.waitForActiveShards())).timeout(request.timeout())).setRefreshPolicy(request.getRefreshPolicy());
                return new Result(deleteRequest, DocWriteResponse.Result.DELETED, updatedSourceAsMap, updateSourceContentType);
            }
        }
        UpdateResponse update = new UpdateResponse(shardId, getResult.getType(), getResult.getId(), getResult.getVersion(), DocWriteResponse.Result.NOOP);
        update.setGetResult(UpdateHelper.extractGetResult(request, request.index(), getResult.getVersion(), updatedSourceAsMap, updateSourceContentType, getResult.internalSourceRef()));
        return new Result(update, DocWriteResponse.Result.NOOP, updatedSourceAsMap, updateSourceContentType);
    }

    private Map<String, Object> executeScript(Script script, Map<String, Object> ctx) {
        try {
            if (this.scriptService != null) {
                ExecutableScript.Factory factory = this.scriptService.compile(script, ExecutableScript.UPDATE_CONTEXT);
                ExecutableScript executableScript = factory.newInstance(script.getParams());
                executableScript.setNextVar("ctx", ctx);
                executableScript.run();
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("failed to execute script", e);
        }
        return ctx;
    }

    public static GetResult extractGetResult(UpdateRequest request, String concreteIndex, long version, Map<String, Object> source, XContentType sourceContentType, @Nullable BytesReference sourceAsBytes) {
        if (!(request.fields() != null && request.fields().length != 0 || request.fetchSource() != null && request.fetchSource().fetchSource())) {
            return null;
        }
        SourceLookup sourceLookup = new SourceLookup();
        sourceLookup.setSource(source);
        boolean sourceRequested = false;
        HashMap<String, DocumentField> fields = null;
        if (request.fields() != null && request.fields().length > 0) {
            for (String field : request.fields()) {
                DocumentField documentField;
                if (field.equals("_source")) {
                    sourceRequested = true;
                    continue;
                }
                Object value = sourceLookup.extractValue(field);
                if (value == null) continue;
                if (fields == null) {
                    fields = new HashMap<String, DocumentField>(2);
                }
                if ((documentField = (DocumentField)fields.get(field)) == null) {
                    documentField = new DocumentField(field, new ArrayList<Object>(2));
                    fields.put(field, documentField);
                }
                documentField.getValues().add(value);
            }
        }
        BytesReference sourceFilteredAsBytes = sourceAsBytes;
        if (request.fetchSource() != null && request.fetchSource().fetchSource()) {
            sourceRequested = true;
            if (request.fetchSource().includes().length > 0 || request.fetchSource().excludes().length > 0) {
                Object value = sourceLookup.filter(request.fetchSource());
                try {
                    int initialCapacity = Math.min(1024, sourceAsBytes.length());
                    BytesStreamOutput streamOutput = new BytesStreamOutput(initialCapacity);
                    try (XContentBuilder builder = new XContentBuilder(sourceContentType.xContent(), streamOutput);){
                        builder.value(value);
                        sourceFilteredAsBytes = BytesReference.bytes(builder);
                    }
                }
                catch (IOException e) {
                    throw new ElasticsearchException("Error filtering source", (Throwable)e, new Object[0]);
                }
            }
        }
        return new GetResult(concreteIndex, request.type(), request.id(), version, true, sourceRequested ? sourceFilteredAsBytes : null, fields);
    }

    public static class ContextFields {
        public static final String CTX = "ctx";
        public static final String OP = "op";
        public static final String SOURCE = "_source";
        public static final String NOW = "_now";
        public static final String INDEX = "_index";
        public static final String TYPE = "_type";
        public static final String ID = "_id";
        public static final String VERSION = "_version";
        public static final String ROUTING = "_routing";
        public static final String PARENT = "_parent";
    }

    static enum UpdateOpType {
        CREATE("create"),
        INDEX("index"),
        DELETE("delete"),
        NONE("none");

        private final String name;

        private UpdateOpType(String name) {
            this.name = name;
        }

        public static UpdateOpType lenientFromString(String operation, Logger logger, String scriptId) {
            switch (operation) {
                case "create": {
                    return CREATE;
                }
                case "index": {
                    return INDEX;
                }
                case "delete": {
                    return DELETE;
                }
                case "none": {
                    return NONE;
                }
            }
            logger.warn("Used upsert operation [{}] for script [{}], doing nothing...", (Object)operation, (Object)scriptId);
            return NONE;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class Result {
        private final Streamable action;
        private final DocWriteResponse.Result result;
        private final Map<String, Object> updatedSourceAsMap;
        private final XContentType updateSourceContentType;

        public Result(Streamable action, DocWriteResponse.Result result, Map<String, Object> updatedSourceAsMap, XContentType updateSourceContentType) {
            this.action = action;
            this.result = result;
            this.updatedSourceAsMap = updatedSourceAsMap;
            this.updateSourceContentType = updateSourceContentType;
        }

        public <T extends Streamable> T action() {
            return (T)this.action;
        }

        public DocWriteResponse.Result getResponseResult() {
            return this.result;
        }

        public Map<String, Object> updatedSourceAsMap() {
            return this.updatedSourceAsMap;
        }

        public XContentType updateSourceContentType() {
            return this.updateSourceContentType;
        }
    }
}

