/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.indices.analyze;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ActionRequestValidationException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ValidateActions;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.support.single.shard.SingleShardRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.Writeable;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentFactory;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentType;

public class AnalyzeRequest
extends SingleShardRequest<AnalyzeRequest> {
    private String[] text;
    private String analyzer;
    private NameOrDefinition tokenizer;
    private final List<NameOrDefinition> tokenFilters = new ArrayList<NameOrDefinition>();
    private final List<NameOrDefinition> charFilters = new ArrayList<NameOrDefinition>();
    private String field;
    private boolean explain = false;
    private String[] attributes = Strings.EMPTY_ARRAY;
    private String normalizer;

    public AnalyzeRequest() {
    }

    public AnalyzeRequest(String index) {
        this.index(index);
    }

    public String[] text() {
        return this.text;
    }

    public AnalyzeRequest text(String ... text) {
        this.text = text;
        return this;
    }

    public AnalyzeRequest analyzer(String analyzer) {
        this.analyzer = analyzer;
        return this;
    }

    public String analyzer() {
        return this.analyzer;
    }

    public AnalyzeRequest tokenizer(String tokenizer) {
        this.tokenizer = new NameOrDefinition(tokenizer);
        return this;
    }

    public AnalyzeRequest tokenizer(Map<String, ?> tokenizer) {
        this.tokenizer = new NameOrDefinition(tokenizer);
        return this;
    }

    public NameOrDefinition tokenizer() {
        return this.tokenizer;
    }

    public AnalyzeRequest addTokenFilter(String tokenFilter) {
        this.tokenFilters.add(new NameOrDefinition(tokenFilter));
        return this;
    }

    public AnalyzeRequest addTokenFilter(Map<String, ?> tokenFilter) {
        this.tokenFilters.add(new NameOrDefinition(tokenFilter));
        return this;
    }

    public List<NameOrDefinition> tokenFilters() {
        return this.tokenFilters;
    }

    public AnalyzeRequest addCharFilter(Map<String, ?> charFilter) {
        this.charFilters.add(new NameOrDefinition(charFilter));
        return this;
    }

    public AnalyzeRequest addCharFilter(String charFilter) {
        this.charFilters.add(new NameOrDefinition(charFilter));
        return this;
    }

    public List<NameOrDefinition> charFilters() {
        return this.charFilters;
    }

    public AnalyzeRequest field(String field) {
        this.field = field;
        return this;
    }

    public String field() {
        return this.field;
    }

    public AnalyzeRequest explain(boolean explain) {
        this.explain = explain;
        return this;
    }

    public boolean explain() {
        return this.explain;
    }

    public AnalyzeRequest attributes(String ... attributes) {
        if (attributes == null) {
            throw new IllegalArgumentException("attributes must not be null");
        }
        this.attributes = attributes;
        return this;
    }

    public String[] attributes() {
        return this.attributes;
    }

    public String normalizer() {
        return this.normalizer;
    }

    public AnalyzeRequest normalizer(String normalizer) {
        this.normalizer = normalizer;
        return this;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.text == null || this.text.length == 0) {
            validationException = ValidateActions.addValidationError("text is missing", validationException);
        }
        if ((this.index == null || this.index.length() == 0) && this.normalizer != null) {
            validationException = ValidateActions.addValidationError("index is required if normalizer is specified", validationException);
        }
        if (this.normalizer != null && (this.tokenizer != null || this.analyzer != null)) {
            validationException = ValidateActions.addValidationError("tokenizer/analyze should be null if normalizer is specified", validationException);
        }
        return validationException;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.text = in.readStringArray();
        this.analyzer = in.readOptionalString();
        this.tokenizer = in.readOptionalWriteable(NameOrDefinition::new);
        this.tokenFilters.addAll(in.readList(NameOrDefinition::new));
        this.charFilters.addAll(in.readList(NameOrDefinition::new));
        this.field = in.readOptionalString();
        this.explain = in.readBoolean();
        this.attributes = in.readStringArray();
        if (in.getVersion().onOrAfter(Version.V_6_0_0_beta1)) {
            this.normalizer = in.readOptionalString();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArray(this.text);
        out.writeOptionalString(this.analyzer);
        out.writeOptionalWriteable(this.tokenizer);
        out.writeList(this.tokenFilters);
        out.writeList(this.charFilters);
        out.writeOptionalString(this.field);
        out.writeBoolean(this.explain);
        out.writeStringArray(this.attributes);
        if (out.getVersion().onOrAfter(Version.V_6_0_0_beta1)) {
            out.writeOptionalString(this.normalizer);
        }
    }

    public static class NameOrDefinition
    implements Writeable {
        public final String name;
        public final Settings definition;

        NameOrDefinition(String name) {
            this.name = Objects.requireNonNull(name);
            this.definition = null;
        }

        NameOrDefinition(Map<String, ?> definition) {
            this.name = null;
            Objects.requireNonNull(definition);
            try {
                XContentBuilder builder = XContentFactory.contentBuilder(XContentType.JSON);
                builder.map(definition);
                this.definition = Settings.builder().loadFromSource(Strings.toString(builder), builder.contentType()).build();
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Failed to parse [" + definition + "]", e);
            }
        }

        NameOrDefinition(StreamInput in) throws IOException {
            this.name = in.readOptionalString();
            this.definition = in.readBoolean() ? Settings.readSettingsFromStream(in) : null;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalString(this.name);
            boolean isNotNullDefinition = this.definition != null;
            out.writeBoolean(isNotNullDefinition);
            if (isNotNullDefinition) {
                Settings.writeSettingsToStream(this.definition, out);
            }
        }
    }
}

