/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.cluster.state;

import java.io.IOException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ActionResponse;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.ClusterModule;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.ClusterName;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.ClusterState;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.unit.ByteSizeValue;

public class ClusterStateResponse
extends ActionResponse {
    private ClusterName clusterName;
    private ClusterState clusterState;
    private ByteSizeValue totalCompressedSize;

    public ClusterStateResponse() {
    }

    public ClusterStateResponse(ClusterName clusterName, ClusterState clusterState, long sizeInBytes) {
        this.clusterName = clusterName;
        this.clusterState = clusterState;
        this.totalCompressedSize = new ByteSizeValue(sizeInBytes);
    }

    public ClusterState getState() {
        return this.clusterState;
    }

    public ClusterName getClusterName() {
        return this.clusterName;
    }

    public ByteSizeValue getTotalCompressedSize() {
        return this.totalCompressedSize;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.clusterName = new ClusterName(in);
        this.clusterState = ClusterState.readFrom(in, null);
        this.totalCompressedSize = in.getVersion().onOrAfter(Version.V_6_0_0_alpha1) ? new ByteSizeValue(in) : new ByteSizeValue(0L);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.clusterName.writeTo(out);
        if (out.getVersion().onOrAfter(Version.V_6_3_0)) {
            this.clusterState.writeTo(out);
        } else {
            ClusterModule.filterCustomsForPre63Clients(this.clusterState).writeTo(out);
        }
        if (out.getVersion().onOrAfter(Version.V_6_0_0_alpha1)) {
            this.totalCompressedSize.writeTo(out);
        }
    }
}

