/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.PostingsEnum;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.Term;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.TermContext;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.TermState;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.Terms;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.TermsEnum;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.BooleanClause;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.BooleanQuery;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.BulkScorer;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.ConstantScoreQuery;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.ConstantScoreScorer;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.ConstantScoreWeight;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.DocIdSet;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.DocIdSetIterator;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.IndexSearcher;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.MultiTermQuery;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.Query;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.Scorer;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.TermQuery;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.Weight;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.DocIdSetBuilder;

final class MultiTermQueryConstantScoreWrapper<Q extends MultiTermQuery>
extends Query {
    private static final int BOOLEAN_REWRITE_TERM_COUNT_THRESHOLD = 16;
    protected final Q query;

    protected MultiTermQueryConstantScoreWrapper(Q query) {
        this.query = query;
    }

    @Override
    public String toString(String field) {
        return ((Query)this.query).toString(field);
    }

    @Override
    public final boolean equals(Object other) {
        return this.sameClassAs(other) && ((MultiTermQuery)this.query).equals(((MultiTermQueryConstantScoreWrapper)other).query);
    }

    @Override
    public final int hashCode() {
        return 31 * this.classHash() + ((MultiTermQuery)this.query).hashCode();
    }

    public Q getQuery() {
        return this.query;
    }

    public final String getField() {
        return ((MultiTermQuery)this.query).getField();
    }

    @Override
    public Weight createWeight(final IndexSearcher searcher, final boolean needsScores, float boost) throws IOException {
        return new ConstantScoreWeight(this, boost){

            private boolean collectTerms(LeafReaderContext context, TermsEnum termsEnum, List<TermAndState> terms) throws IOException {
                int threshold = Math.min(16, BooleanQuery.getMaxClauseCount());
                for (int i = 0; i < threshold; ++i) {
                    BytesRef term = termsEnum.next();
                    if (term == null) {
                        return true;
                    }
                    TermState state = termsEnum.termState();
                    terms.add(new TermAndState(BytesRef.deepCopyOf(term), state, termsEnum.docFreq(), termsEnum.totalTermFreq()));
                }
                return termsEnum.next() == null;
            }

            private WeightOrDocIdSet rewrite(LeafReaderContext context) throws IOException {
                Terms terms = context.reader().terms(((MultiTermQuery)MultiTermQueryConstantScoreWrapper.this.query).field);
                if (terms == null) {
                    return new WeightOrDocIdSet((DocIdSet)null);
                }
                TermsEnum termsEnum = ((MultiTermQuery)MultiTermQueryConstantScoreWrapper.this.query).getTermsEnum(terms);
                assert (termsEnum != null);
                PostingsEnum docs = null;
                ArrayList<TermAndState> collectedTerms = new ArrayList<TermAndState>();
                if (this.collectTerms(context, termsEnum, collectedTerms)) {
                    BooleanQuery.Builder bq = new BooleanQuery.Builder();
                    for (TermAndState t : collectedTerms) {
                        TermContext termContext = new TermContext(searcher.getTopReaderContext());
                        termContext.register(t.state, context.ord, t.docFreq, t.totalTermFreq);
                        bq.add(new TermQuery(new Term(((MultiTermQuery)MultiTermQueryConstantScoreWrapper.this.query).field, t.term), termContext), BooleanClause.Occur.SHOULD);
                    }
                    ConstantScoreQuery q = new ConstantScoreQuery(bq.build());
                    Weight weight = searcher.rewrite(q).createWeight(searcher, needsScores, this.score());
                    return new WeightOrDocIdSet(weight);
                }
                DocIdSetBuilder builder = new DocIdSetBuilder(context.reader().maxDoc(), terms);
                if (!collectedTerms.isEmpty()) {
                    TermsEnum termsEnum2 = terms.iterator();
                    for (TermAndState t : collectedTerms) {
                        termsEnum2.seekExact(t.term, t.state);
                        docs = termsEnum2.postings(docs, 0);
                        builder.add(docs);
                    }
                }
                do {
                    docs = termsEnum.postings(docs, 0);
                    builder.add(docs);
                } while (termsEnum.next() != null);
                return new WeightOrDocIdSet(builder.build());
            }

            private Scorer scorer(DocIdSet set) throws IOException {
                if (set == null) {
                    return null;
                }
                DocIdSetIterator disi = set.iterator();
                if (disi == null) {
                    return null;
                }
                return new ConstantScoreScorer((Weight)this, this.score(), disi);
            }

            @Override
            public BulkScorer bulkScorer(LeafReaderContext context) throws IOException {
                WeightOrDocIdSet weightOrBitSet = this.rewrite(context);
                if (weightOrBitSet.weight != null) {
                    return weightOrBitSet.weight.bulkScorer(context);
                }
                Scorer scorer = this.scorer(weightOrBitSet.set);
                if (scorer == null) {
                    return null;
                }
                return new Weight.DefaultBulkScorer(scorer);
            }

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                WeightOrDocIdSet weightOrBitSet = this.rewrite(context);
                if (weightOrBitSet.weight != null) {
                    return weightOrBitSet.weight.scorer(context);
                }
                return this.scorer(weightOrBitSet.set);
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return true;
            }
        };
    }

    private static class WeightOrDocIdSet {
        final Weight weight;
        final DocIdSet set;

        WeightOrDocIdSet(Weight weight) {
            this.weight = Objects.requireNonNull(weight);
            this.set = null;
        }

        WeightOrDocIdSet(DocIdSet bitset) {
            this.set = bitset;
            this.weight = null;
        }
    }

    private static class TermAndState {
        final BytesRef term;
        final TermState state;
        final int docFreq;
        final long totalTermFreq;

        TermAndState(BytesRef term, TermState state, int docFreq, long totalTermFreq) {
            this.term = term;
            this.state = state;
            this.docFreq = docFreq;
            this.totalTermFreq = totalTermFreq;
        }
    }
}

