/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.threadpool;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.unit.TimeValue;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.util.concurrent.EsAbortPolicy;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.util.concurrent.EsExecutors;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;

public interface Scheduler {
    public static ScheduledThreadPoolExecutor initScheduler(Settings settings) {
        ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(1, EsExecutors.daemonThreadFactory(settings, "scheduler"), new EsAbortPolicy());
        scheduler.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        scheduler.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        scheduler.setRemoveOnCancelPolicy(true);
        return scheduler;
    }

    public static boolean terminate(ScheduledThreadPoolExecutor scheduledThreadPoolExecutor, long timeout, TimeUnit timeUnit) {
        scheduledThreadPoolExecutor.shutdown();
        if (Scheduler.awaitTermination(scheduledThreadPoolExecutor, timeout, timeUnit)) {
            return true;
        }
        scheduledThreadPoolExecutor.shutdownNow();
        return Scheduler.awaitTermination(scheduledThreadPoolExecutor, timeout, timeUnit);
    }

    public static boolean awaitTermination(ScheduledThreadPoolExecutor scheduledThreadPoolExecutor, long timeout, TimeUnit timeUnit) {
        try {
            if (scheduledThreadPoolExecutor.awaitTermination(timeout, timeUnit)) {
                return true;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return false;
    }

    default public Runnable preserveContext(Runnable command) {
        return command;
    }

    public ScheduledFuture<?> schedule(TimeValue var1, String var2, Runnable var3);

    default public Cancellable scheduleWithFixedDelay(Runnable command, TimeValue interval, String executor) {
        return new ReschedulingRunnable(command, interval, executor, this, e -> {}, e -> {});
    }

    public static final class ReschedulingRunnable
    extends AbstractRunnable
    implements Cancellable {
        private final Runnable runnable;
        private final TimeValue interval;
        private final String executor;
        private final Scheduler scheduler;
        private final Consumer<Exception> rejectionConsumer;
        private final Consumer<Exception> failureConsumer;
        private volatile boolean run = true;

        ReschedulingRunnable(Runnable runnable, TimeValue interval, String executor, Scheduler scheduler, Consumer<Exception> rejectionConsumer, Consumer<Exception> failureConsumer) {
            this.runnable = runnable;
            this.interval = interval;
            this.executor = executor;
            this.scheduler = scheduler;
            this.rejectionConsumer = rejectionConsumer;
            this.failureConsumer = failureConsumer;
            scheduler.schedule(interval, executor, this);
        }

        @Override
        public void cancel() {
            this.run = false;
        }

        @Override
        public boolean isCancelled() {
            return !this.run;
        }

        @Override
        public void doRun() {
            if (this.run) {
                this.runnable.run();
            }
        }

        @Override
        public void onFailure(Exception e) {
            this.failureConsumer.accept(e);
        }

        @Override
        public void onRejection(Exception e) {
            this.run = false;
            this.rejectionConsumer.accept(e);
        }

        @Override
        public void onAfter() {
            if (this.run) {
                try {
                    this.scheduler.schedule(this.interval, this.executor, this);
                }
                catch (EsRejectedExecutionException e) {
                    this.onRejection(e);
                }
            }
        }
    }

    public static interface Cancellable {
        public void cancel();

        public boolean isCancelled();
    }
}

