/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.pipeline.bucketmetrics.min;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.DocValueFormat;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.InternalAggregation;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.pipeline.BucketHelpers;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.pipeline.bucketmetrics.BucketMetricsPipelineAggregator;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.pipeline.bucketmetrics.InternalBucketMetricValue;

public class MinBucketPipelineAggregator
extends BucketMetricsPipelineAggregator {
    private List<String> minBucketKeys;
    private double minValue;

    protected MinBucketPipelineAggregator(String name, String[] bucketsPaths, BucketHelpers.GapPolicy gapPolicy, DocValueFormat formatter, Map<String, Object> metaData) {
        super(name, bucketsPaths, gapPolicy, formatter, metaData);
    }

    public MinBucketPipelineAggregator(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    public String getWriteableName() {
        return "min_bucket";
    }

    @Override
    protected void preCollection() {
        this.minBucketKeys = new ArrayList<String>();
        this.minValue = Double.POSITIVE_INFINITY;
    }

    @Override
    protected void collectBucketValue(String bucketKey, Double bucketValue) {
        if (bucketValue < this.minValue) {
            this.minBucketKeys.clear();
            this.minBucketKeys.add(bucketKey);
            this.minValue = bucketValue;
        } else if (bucketValue.equals(this.minValue)) {
            this.minBucketKeys.add(bucketKey);
        }
    }

    @Override
    protected InternalAggregation buildAggregation(List<PipelineAggregator> pipelineAggregators, Map<String, Object> metadata) {
        String[] keys = this.minBucketKeys.toArray(new String[this.minBucketKeys.size()]);
        return new InternalBucketMetricValue(this.name(), keys, this.minValue, this.format, Collections.emptyList(), this.metaData());
    }
}

