/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.util.concurrent;

import java.util.concurrent.TimeUnit;
import java.util.function.LongSupplier;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.Priority;

public abstract class PrioritizedRunnable
implements Runnable,
Comparable<PrioritizedRunnable> {
    private final Priority priority;
    private final long creationDate;
    private final LongSupplier relativeTimeProvider;

    public static PrioritizedRunnable wrap(Runnable runnable, Priority priority) {
        return new Wrapped(runnable, priority);
    }

    protected PrioritizedRunnable(Priority priority) {
        this(priority, System::nanoTime);
    }

    PrioritizedRunnable(Priority priority, LongSupplier relativeTimeProvider) {
        this.priority = priority;
        this.creationDate = relativeTimeProvider.getAsLong();
        this.relativeTimeProvider = relativeTimeProvider;
    }

    public long getCreationDateInNanos() {
        return this.creationDate;
    }

    public long getAgeInMillis() {
        return TimeUnit.MILLISECONDS.convert(this.relativeTimeProvider.getAsLong() - this.creationDate, TimeUnit.NANOSECONDS);
    }

    @Override
    public int compareTo(PrioritizedRunnable pr) {
        return this.priority.compareTo(pr.priority);
    }

    public Priority priority() {
        return this.priority;
    }

    static class Wrapped
    extends PrioritizedRunnable {
        private final Runnable runnable;

        private Wrapped(Runnable runnable, Priority priority) {
            super(priority);
            this.runnable = runnable;
        }

        @Override
        public void run() {
            this.runnable.run();
        }
    }
}

