/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cli;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.util.KeyValuePair;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cli.Command;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cli.CommandLoggingConfigurator;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cli.Terminal;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cli.UserException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.SuppressForbidden;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.env.Environment;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.node.InternalSettingsPreparer;

public abstract class EnvironmentAwareCommand
extends Command {
    private final OptionSpec<KeyValuePair> settingOption;

    public EnvironmentAwareCommand(String description) {
        this(description, CommandLoggingConfigurator::configureLoggingWithoutConfig);
    }

    public EnvironmentAwareCommand(String description, Runnable beforeMain) {
        super(description, beforeMain);
        this.settingOption = this.parser.accepts("E", "Configure a setting").withRequiredArg().ofType(KeyValuePair.class);
    }

    @Override
    protected void execute(Terminal terminal, OptionSet options) throws Exception {
        HashMap<String, String> settings = new HashMap<String, String>();
        for (KeyValuePair kvp : this.settingOption.values(options)) {
            if (kvp.value.isEmpty()) {
                throw new UserException(64, "setting [" + kvp.key + "] must not be empty");
            }
            if (settings.containsKey(kvp.key)) {
                String message = String.format(Locale.ROOT, "setting [%s] already set, saw [%s] and [%s]", kvp.key, settings.get(kvp.key), kvp.value);
                throw new UserException(64, message);
            }
            settings.put(kvp.key, kvp.value);
        }
        EnvironmentAwareCommand.putSystemPropertyIfSettingIsMissing(settings, "path.data", "es.path.data");
        EnvironmentAwareCommand.putSystemPropertyIfSettingIsMissing(settings, "path.home", "es.path.home");
        EnvironmentAwareCommand.putSystemPropertyIfSettingIsMissing(settings, "path.logs", "es.path.logs");
        this.execute(terminal, options, this.createEnv(terminal, settings));
    }

    protected Environment createEnv(Terminal terminal, Map<String, String> settings) throws UserException {
        String esPathConf = System.getProperty("es.path.conf");
        if (esPathConf == null) {
            throw new UserException(78, "the system property [es.path.conf] must be set");
        }
        return InternalSettingsPreparer.prepareEnvironment(Settings.EMPTY, terminal, settings, EnvironmentAwareCommand.getConfigPath(esPathConf));
    }

    @SuppressForbidden(reason="need path to construct environment")
    private static Path getConfigPath(String pathConf) {
        return Paths.get(pathConf, new String[0]);
    }

    private static void putSystemPropertyIfSettingIsMissing(Map<String, String> settings, String setting, String key) {
        String value = System.getProperty(key);
        if (value != null) {
            if (settings.containsKey(setting)) {
                String message = String.format(Locale.ROOT, "duplicate setting [%s] found via command-line [%s] and system property [%s]", setting, settings.get(setting), value);
                throw new IllegalArgumentException(message);
            }
            settings.put(setting, value);
        }
    }

    protected abstract void execute(Terminal var1, OptionSet var2, Environment var3) throws Exception;
}

