/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ingest;

import java.util.HashMap;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ActionListener;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.cluster.node.info.NodeInfo;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.cluster.node.info.NodesInfoRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.cluster.node.info.NodesInfoResponse;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.cluster.node.info.TransportNodesInfoAction;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ingest.PutPipelineRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ingest.WritePipelineResponse;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.support.ActionFilters;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.ClusterState;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.block.ClusterBlockException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.node.DiscoveryNode;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.service.ClusterService;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.inject.Inject;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.ingest.IngestInfo;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.ingest.PipelineStore;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.node.NodeService;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.threadpool.ThreadPool;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.transport.TransportService;

public class PutPipelineTransportAction
extends TransportMasterNodeAction<PutPipelineRequest, WritePipelineResponse> {
    private final PipelineStore pipelineStore;
    private final ClusterService clusterService;
    private final TransportNodesInfoAction nodesInfoAction;

    @Inject
    public PutPipelineTransportAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, NodeService nodeService, TransportNodesInfoAction nodesInfoAction) {
        super(settings, "cluster:admin/ingest/pipeline/put", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, PutPipelineRequest::new);
        this.clusterService = clusterService;
        this.nodesInfoAction = nodesInfoAction;
        this.pipelineStore = nodeService.getIngestService().getPipelineStore();
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected WritePipelineResponse newResponse() {
        return new WritePipelineResponse();
    }

    @Override
    protected void masterOperation(final PutPipelineRequest request, ClusterState state, final ActionListener<WritePipelineResponse> listener) throws Exception {
        NodesInfoRequest nodesInfoRequest = new NodesInfoRequest();
        nodesInfoRequest.clear();
        nodesInfoRequest.ingest(true);
        this.nodesInfoAction.execute(nodesInfoRequest, new ActionListener<NodesInfoResponse>(){

            @Override
            public void onResponse(NodesInfoResponse nodeInfos) {
                try {
                    HashMap<DiscoveryNode, IngestInfo> ingestInfos = new HashMap<DiscoveryNode, IngestInfo>();
                    for (NodeInfo nodeInfo : nodeInfos.getNodes()) {
                        ingestInfos.put(nodeInfo.getNode(), nodeInfo.getIngest());
                    }
                    PutPipelineTransportAction.this.pipelineStore.put(PutPipelineTransportAction.this.clusterService, ingestInfos, request, listener);
                }
                catch (Exception e) {
                    this.onFailure(e);
                }
            }

            @Override
            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }

    @Override
    protected ClusterBlockException checkBlock(PutPipelineRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

