/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.suggest.fst;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.ArrayUtil;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.fst.FST;

public class FSTCompletion {
    public static final int DEFAULT_BUCKETS = 10;
    private static final ArrayList<Completion> EMPTY_RESULT = new ArrayList();
    private final FST<Object> automaton;
    private final FST.Arc<Object>[] rootArcs;
    private boolean exactFirst;
    private boolean higherWeightsFirst;

    public FSTCompletion(FST<Object> automaton, boolean higherWeightsFirst, boolean exactFirst) {
        this.automaton = automaton;
        this.rootArcs = automaton != null ? FSTCompletion.cacheRootArcs(automaton) : new FST.Arc[0];
        this.higherWeightsFirst = higherWeightsFirst;
        this.exactFirst = exactFirst;
    }

    public FSTCompletion(FST<Object> automaton) {
        this(automaton, true, true);
    }

    private static FST.Arc<Object>[] cacheRootArcs(FST<Object> automaton) {
        try {
            ArrayList<FST.Arc<Object>> rootArcs = new ArrayList<FST.Arc<Object>>();
            FST.Arc<Object> arc = automaton.getFirstArc(new FST.Arc());
            FST.BytesReader fstReader = automaton.getBytesReader();
            automaton.readFirstTargetArc(arc, arc, fstReader);
            while (true) {
                rootArcs.add(new FST.Arc<Object>().copyFrom(arc));
                if (arc.isLast()) break;
                automaton.readNextArc(arc, fstReader);
            }
            Collections.reverse(rootArcs);
            return rootArcs.toArray(new FST.Arc[rootArcs.size()]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private int getExactMatchStartingFromRootArc(int rootArcIndex, BytesRef utf8) {
        try {
            FST.Arc<Object> scratch = new FST.Arc<Object>();
            FST.BytesReader fstReader = this.automaton.getBytesReader();
            while (rootArcIndex < this.rootArcs.length) {
                FST.Arc<Object> rootArc = this.rootArcs[rootArcIndex];
                FST.Arc<Object> arc = scratch.copyFrom(rootArc);
                if (this.descendWithPrefix(arc, utf8)) {
                    this.automaton.readFirstTargetArc(arc, arc, fstReader);
                    if (arc.label == -1) {
                        return rootArc.label;
                    }
                }
                ++rootArcIndex;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return -1;
    }

    public List<Completion> lookup(CharSequence key, int num) {
        if (key.length() == 0 || this.automaton == null) {
            return EMPTY_RESULT;
        }
        try {
            BytesRef keyUtf8 = new BytesRef(key);
            if (!this.higherWeightsFirst && this.rootArcs.length > 1) {
                return this.lookupSortedAlphabetically(keyUtf8, num);
            }
            return this.lookupSortedByWeight(keyUtf8, num, false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private List<Completion> lookupSortedAlphabetically(BytesRef key, int num) throws IOException {
        List<Completion> res = this.lookupSortedByWeight(key, num, true);
        Collections.sort(res);
        if (res.size() > num) {
            res = res.subList(0, num);
        }
        return res;
    }

    private ArrayList<Completion> lookupSortedByWeight(BytesRef key, int num, boolean collectAll) throws IOException {
        ArrayList<Completion> res = new ArrayList<Completion>(Math.min(10, num));
        BytesRef output = BytesRef.deepCopyOf(key);
        for (int i = 0; i < this.rootArcs.length; ++i) {
            int exactMatchBucket;
            FST.Arc<Object> rootArc = this.rootArcs[i];
            FST.Arc<Object> arc = new FST.Arc<Object>().copyFrom(rootArc);
            if (!this.descendWithPrefix(arc, key)) continue;
            output.length = key.length - 1;
            if (!this.collect(res, num, rootArc.label, output, arc) || collectAll) continue;
            if (!this.exactFirst || this.checkExistingAndReorder(res, key) || (exactMatchBucket = this.getExactMatchStartingFromRootArc(i, key)) == -1) break;
            while (res.size() >= num) {
                res.remove(res.size() - 1);
            }
            res.add(0, new Completion(key, exactMatchBucket));
            break;
        }
        return res;
    }

    private boolean checkExistingAndReorder(ArrayList<Completion> list, BytesRef key) {
        int i = list.size();
        while (--i >= 0) {
            if (!key.equals(list.get((int)i).utf8)) continue;
            list.add(0, list.remove(i));
            return true;
        }
        return false;
    }

    private boolean descendWithPrefix(FST.Arc<Object> arc, BytesRef utf8) throws IOException {
        int max = utf8.offset + utf8.length;
        FST.BytesReader fstReader = this.automaton.getBytesReader();
        for (int i = utf8.offset; i < max; ++i) {
            if (this.automaton.findTargetArc(utf8.bytes[i] & 0xFF, arc, arc, fstReader) != null) continue;
            return false;
        }
        return true;
    }

    private boolean collect(List<Completion> res, int num, int bucket, BytesRef output, FST.Arc<Object> arc) throws IOException {
        if (output.length == output.bytes.length) {
            output.bytes = ArrayUtil.grow(output.bytes);
        }
        assert (output.offset == 0);
        output.bytes[output.length++] = (byte)arc.label;
        FST.BytesReader fstReader = this.automaton.getBytesReader();
        this.automaton.readFirstTargetArc(arc, arc, fstReader);
        while (true) {
            if (arc.label == -1) {
                res.add(new Completion(output, bucket));
                if (res.size() >= num) {
                    return true;
                }
            } else {
                int save = output.length;
                if (this.collect(res, num, bucket, output, new FST.Arc<Object>().copyFrom(arc))) {
                    return true;
                }
                output.length = save;
            }
            if (arc.isLast()) break;
            this.automaton.readNextArc(arc, fstReader);
        }
        return false;
    }

    public int getBucketCount() {
        return this.rootArcs.length;
    }

    public int getBucket(CharSequence key) {
        return this.getExactMatchStartingFromRootArc(0, new BytesRef(key));
    }

    public FST<Object> getFST() {
        return this.automaton;
    }

    public static final class Completion
    implements Comparable<Completion> {
        public final BytesRef utf8;
        public final int bucket;

        Completion(BytesRef key, int bucket) {
            this.utf8 = BytesRef.deepCopyOf(key);
            this.bucket = bucket;
        }

        public String toString() {
            return this.utf8.utf8ToString() + "/" + this.bucket;
        }

        @Override
        public int compareTo(Completion o) {
            return this.utf8.compareTo(o.utf8);
        }
    }
}

