/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.suggest.completion;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.CharArraySet;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.ScoreDoc;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.suggest.Lookup;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.PriorityQueue;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.lucene.Lucene;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.text.Text;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ObjectParser;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentParserUtils;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.SearchHit;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.suggest.Suggest;

public final class CompletionSuggestion
extends Suggest.Suggestion<Entry> {
    public static final String NAME = "completion";
    public static final int TYPE = 4;
    private boolean skipDuplicates;

    public CompletionSuggestion() {
    }

    public CompletionSuggestion(String name, int size, boolean skipDuplicates) {
        super(name, size);
        this.skipDuplicates = skipDuplicates;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        if (in.getVersion().onOrAfter(Version.V_6_1_0)) {
            this.skipDuplicates = in.readBoolean();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (out.getVersion().onOrAfter(Version.V_6_1_0)) {
            out.writeBoolean(this.skipDuplicates);
        }
    }

    public List<Entry.Option> getOptions() {
        if (!this.entries.isEmpty()) {
            assert (this.entries.size() == 1) : "CompletionSuggestion must have only one entry";
            return ((Entry)this.entries.get(0)).getOptions();
        }
        return Collections.emptyList();
    }

    public boolean hasScoreDocs() {
        return this.getOptions().size() > 0;
    }

    public static CompletionSuggestion fromXContent(XContentParser parser, String name) throws IOException {
        CompletionSuggestion suggestion = new CompletionSuggestion(name, -1, false);
        CompletionSuggestion.parseEntries(parser, suggestion, Entry::fromXContent);
        return suggestion;
    }

    public static CompletionSuggestion reduceTo(List<Suggest.Suggestion<Entry>> toReduce) {
        if (toReduce.isEmpty()) {
            return null;
        }
        CompletionSuggestion leader = (CompletionSuggestion)toReduce.get(0);
        Entry leaderEntry = (Entry)leader.getEntries().get(0);
        String name = leader.getName();
        if (toReduce.size() == 1) {
            return leader;
        }
        OptionPriorityQueue priorityQueue = new OptionPriorityQueue(leader.getSize(), Suggest.COMPARATOR);
        CharArraySet seenSurfaceForms = leader.skipDuplicates ? new CharArraySet(leader.getSize(), false) : null;
        block0: for (Suggest.Suggestion<Entry> suggestion : toReduce) {
            assert (suggestion.getName().equals(name)) : "name should be identical across all suggestions";
            for (Entry.Option option : ((CompletionSuggestion)suggestion).getOptions()) {
                if (leader.skipDuplicates) {
                    assert (((CompletionSuggestion)suggestion).skipDuplicates);
                    String text = option.getText().string();
                    if (seenSurfaceForms.contains(text)) continue;
                    seenSurfaceForms.add(text);
                }
                if (option != priorityQueue.insertWithOverflow(option)) continue;
                continue block0;
            }
        }
        CompletionSuggestion suggestion = new CompletionSuggestion(leader.getName(), leader.getSize(), leader.skipDuplicates);
        Entry entry = new Entry(leaderEntry.getText(), leaderEntry.getOffset(), leaderEntry.getLength());
        Collections.addAll(entry.getOptions(), priorityQueue.get());
        suggestion.addTerm(entry);
        return suggestion;
    }

    @Override
    public Suggest.Suggestion<Entry> reduce(List<Suggest.Suggestion<Entry>> toReduce) {
        return CompletionSuggestion.reduceTo(toReduce);
    }

    public void setShardIndex(int shardIndex) {
        if (!this.entries.isEmpty()) {
            for (Entry.Option option : this.getOptions()) {
                option.setShardIndex(shardIndex);
            }
        }
    }

    @Override
    public int getWriteableType() {
        return 4;
    }

    @Override
    protected String getType() {
        return NAME;
    }

    @Override
    protected Entry newEntry() {
        return new Entry();
    }

    public static final class Entry
    extends Suggest.Suggestion.Entry<Option> {
        private static ObjectParser<Entry, Void> PARSER = new ObjectParser("CompletionSuggestionEntryParser", true, Entry::new);

        public Entry(Text text, int offset, int length) {
            super(text, offset, length);
        }

        Entry() {
        }

        @Override
        protected Option newOption() {
            return new Option();
        }

        public static Entry fromXContent(XContentParser parser) {
            return PARSER.apply(parser, null);
        }

        static {
            Entry.declareCommonFields(PARSER);
            PARSER.declareObjectArray(Suggest.Suggestion.Entry::addOptions, (p, c) -> Option.fromXContent(p), new ParseField("options", new String[0]));
        }

        public static class Option
        extends Suggest.Suggestion.Entry.Option {
            private Map<String, Set<CharSequence>> contexts = Collections.emptyMap();
            private ScoreDoc doc;
            private SearchHit hit;
            public static final ParseField CONTEXTS = new ParseField("contexts", new String[0]);
            private static ObjectParser<Map<String, Object>, Void> PARSER = new ObjectParser("CompletionOptionParser", true, HashMap::new);

            public Option(int docID, Text text, float score, Map<String, Set<CharSequence>> contexts) {
                super(text, score);
                this.doc = new ScoreDoc(docID, score);
                this.contexts = Objects.requireNonNull(contexts, "context map cannot be null");
            }

            protected Option() {
            }

            @Override
            protected void mergeInto(Suggest.Suggestion.Entry.Option otherOption) {
                throw new UnsupportedOperationException();
            }

            public Map<String, Set<CharSequence>> getContexts() {
                return this.contexts;
            }

            public ScoreDoc getDoc() {
                return this.doc;
            }

            public SearchHit getHit() {
                return this.hit;
            }

            public void setShardIndex(int shardIndex) {
                this.doc.shardIndex = shardIndex;
            }

            public void setHit(SearchHit hit) {
                this.hit = hit;
            }

            @Override
            protected XContentBuilder innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                builder.field(TEXT.getPreferredName(), this.getText());
                if (this.hit != null) {
                    this.hit.toInnerXContent(builder, params);
                } else {
                    builder.field(SCORE.getPreferredName(), this.getScore());
                }
                if (this.contexts.size() > 0) {
                    builder.startObject(CONTEXTS.getPreferredName());
                    for (Map.Entry<String, Set<CharSequence>> entry : this.contexts.entrySet()) {
                        builder.startArray(entry.getKey());
                        for (CharSequence context : entry.getValue()) {
                            builder.value(context.toString());
                        }
                        builder.endArray();
                    }
                    builder.endObject();
                }
                return builder;
            }

            private static Map<String, Set<CharSequence>> parseContexts(XContentParser parser) throws IOException {
                HashMap<String, Set<CharSequence>> contexts = new HashMap<String, Set<CharSequence>>();
                while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                    XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, parser.currentToken(), parser::getTokenLocation);
                    String key = parser.currentName();
                    XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_ARRAY, parser.nextToken(), parser::getTokenLocation);
                    HashSet<String> values = new HashSet<String>();
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        XContentParserUtils.ensureExpectedToken(XContentParser.Token.VALUE_STRING, parser.currentToken(), parser::getTokenLocation);
                        values.add(parser.text());
                    }
                    contexts.put(key, values);
                }
                return contexts;
            }

            public static Option fromXContent(XContentParser parser) {
                Map<String, Object> values = PARSER.apply(parser, null);
                Text text = new Text((String)values.get(Suggest.Suggestion.Entry.Option.TEXT.getPreferredName()));
                Float score = (Float)values.get(Suggest.Suggestion.Entry.Option.SCORE.getPreferredName());
                Map<String, Set<CharSequence>> contexts = (Map<String, Set<CharSequence>>)values.get(CONTEXTS.getPreferredName());
                if (contexts == null) {
                    contexts = Collections.emptyMap();
                }
                SearchHit hit = null;
                if (score == null) {
                    hit = SearchHit.createFromMap(values);
                    score = Float.valueOf(hit.getScore());
                }
                Option option = new Option(-1, text, score.floatValue(), contexts);
                option.setHit(hit);
                return option;
            }

            @Override
            public void readFrom(StreamInput in) throws IOException {
                super.readFrom(in);
                this.doc = Lucene.readScoreDoc(in);
                if (in.readBoolean()) {
                    this.hit = SearchHit.readSearchHit(in);
                }
                int contextSize = in.readInt();
                this.contexts = new LinkedHashMap<String, Set<CharSequence>>(contextSize);
                for (int i = 0; i < contextSize; ++i) {
                    String contextName = in.readString();
                    int nContexts = in.readVInt();
                    HashSet<String> contexts = new HashSet<String>(nContexts);
                    for (int j = 0; j < nContexts; ++j) {
                        contexts.add(in.readString());
                    }
                    this.contexts.put(contextName, contexts);
                }
            }

            @Override
            public void writeTo(StreamOutput out) throws IOException {
                super.writeTo(out);
                Lucene.writeScoreDoc(out, this.doc);
                if (this.hit != null) {
                    out.writeBoolean(true);
                    this.hit.writeTo(out);
                } else {
                    out.writeBoolean(false);
                }
                out.writeInt(this.contexts.size());
                for (Map.Entry<String, Set<CharSequence>> entry : this.contexts.entrySet()) {
                    out.writeString(entry.getKey());
                    out.writeVInt(entry.getValue().size());
                    for (CharSequence ctx : entry.getValue()) {
                        out.writeString(ctx.toString());
                    }
                }
            }

            public String toString() {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("text:");
                stringBuilder.append(this.getText());
                stringBuilder.append(" score:");
                stringBuilder.append(this.getScore());
                stringBuilder.append(" context:[");
                for (Map.Entry<String, Set<CharSequence>> entry : this.contexts.entrySet()) {
                    stringBuilder.append(" ");
                    stringBuilder.append(entry.getKey());
                    stringBuilder.append(":");
                    stringBuilder.append(entry.getValue());
                }
                stringBuilder.append("]");
                return stringBuilder.toString();
            }

            static {
                SearchHit.declareInnerHitsParseFields(PARSER);
                PARSER.declareString((map, value) -> map.put(Suggest.Suggestion.Entry.Option.TEXT.getPreferredName(), value), Suggest.Suggestion.Entry.Option.TEXT);
                PARSER.declareFloat((map, value) -> map.put(Suggest.Suggestion.Entry.Option.SCORE.getPreferredName(), value), Suggest.Suggestion.Entry.Option.SCORE);
                PARSER.declareObject((map, value) -> map.put(CONTEXTS.getPreferredName(), value), (p, c) -> Option.parseContexts(p), CONTEXTS);
            }
        }
    }

    private static final class OptionPriorityQueue
    extends PriorityQueue<Entry.Option> {
        private final Comparator<Suggest.Suggestion.Entry.Option> comparator;

        OptionPriorityQueue(int maxSize, Comparator<Suggest.Suggestion.Entry.Option> comparator) {
            super(maxSize);
            this.comparator = comparator;
        }

        @Override
        protected boolean lessThan(Entry.Option a, Entry.Option b) {
            int cmp = this.comparator.compare(a, b);
            if (cmp != 0) {
                return cmp > 0;
            }
            return Lookup.CHARSEQUENCE_COMPARATOR.compare(a.getText().string(), b.getText().string()) > 0;
        }

        Entry.Option[] get() {
            int size = this.size();
            Entry.Option[] results = new Entry.Option[size];
            for (int i = size - 1; i >= 0; --i) {
                results[i] = (Entry.Option)this.pop();
            }
            return results;
        }
    }
}

