/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.support;

import java.io.IOException;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.geo.GeoPoint;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.fielddata.IndexFieldData;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.fielddata.IndexGeoPointFieldData;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.fielddata.IndexOrdinalsFieldData;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.mapper.MappedFieldType;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.query.QueryShardContext;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.script.Script;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.script.SearchScript;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.DocValueFormat;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.support.FieldContext;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.support.MissingValues;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.support.ValueType;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.support.ValuesSource;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.joda.time.DateTimeZone;

public class ValuesSourceConfig<VS extends ValuesSource> {
    private final ValuesSourceType valueSourceType;
    private FieldContext fieldContext;
    private SearchScript.LeafFactory script;
    private ValueType scriptValueType;
    private boolean unmapped = false;
    private DocValueFormat format = DocValueFormat.RAW;
    private Object missing;
    private DateTimeZone timeZone;

    public static <VS extends ValuesSource> ValuesSourceConfig<VS> resolve(QueryShardContext context, ValueType valueType, String field, Script script, Object missing, DateTimeZone timeZone, String format) {
        if (field == null) {
            ValuesSourceType valuesSourceType;
            if (script == null) {
                ValuesSourceConfig<VS> config = new ValuesSourceConfig<VS>(ValuesSourceType.ANY);
                config.format(ValuesSourceConfig.resolveFormat(null, valueType));
                return config;
            }
            ValuesSourceType valuesSourceType2 = valuesSourceType = valueType != null ? valueType.getValuesSourceType() : ValuesSourceType.ANY;
            if (valuesSourceType == ValuesSourceType.ANY) {
                valuesSourceType = ValuesSourceType.BYTES;
            }
            ValuesSourceConfig<VS> config = new ValuesSourceConfig<VS>(valuesSourceType);
            config.missing(missing);
            config.timezone(timeZone);
            config.format(ValuesSourceConfig.resolveFormat(format, valueType));
            config.script(ValuesSourceConfig.createScript(script, context));
            config.scriptValueType(valueType);
            return config;
        }
        MappedFieldType fieldType = context.fieldMapper(field);
        if (fieldType == null) {
            ValuesSourceType valuesSourceType = valueType != null ? valueType.getValuesSourceType() : ValuesSourceType.ANY;
            ValuesSourceConfig<VS> config = new ValuesSourceConfig<VS>(valuesSourceType);
            config.missing(missing);
            config.timezone(timeZone);
            config.format(ValuesSourceConfig.resolveFormat(format, valueType));
            config.unmapped(true);
            if (valueType != null) {
                config.scriptValueType(valueType);
            }
            return config;
        }
        Object indexFieldData = context.getForField(fieldType);
        ValuesSourceConfig<VS> config = valueType == null ? (indexFieldData instanceof IndexNumericFieldData ? new ValuesSourceConfig<VS>(ValuesSourceType.NUMERIC) : (indexFieldData instanceof IndexGeoPointFieldData ? new ValuesSourceConfig<VS>(ValuesSourceType.GEOPOINT) : new ValuesSourceConfig<VS>(ValuesSourceType.BYTES))) : new ValuesSourceConfig<VS>(valueType.getValuesSourceType());
        config.fieldContext(new FieldContext(field, (IndexFieldData<?>)indexFieldData, fieldType));
        config.missing(missing);
        config.timezone(timeZone);
        config.script(ValuesSourceConfig.createScript(script, context));
        config.format(fieldType.docValueFormat(format, timeZone));
        return config;
    }

    private static SearchScript.LeafFactory createScript(Script script, QueryShardContext context) {
        if (script == null) {
            return null;
        }
        SearchScript.Factory factory = context.getScriptService().compile(script, SearchScript.AGGS_CONTEXT);
        return factory.newFactory(script.getParams(), context.lookup());
    }

    private static DocValueFormat resolveFormat(@Nullable String format, @Nullable ValueType valueType) {
        if (valueType == null) {
            return DocValueFormat.RAW;
        }
        DocValueFormat valueFormat = valueType.defaultFormat;
        if (valueFormat instanceof DocValueFormat.Decimal && format != null) {
            valueFormat = new DocValueFormat.Decimal(format);
        }
        return valueFormat;
    }

    public ValuesSourceConfig(ValuesSourceType valueSourceType) {
        this.valueSourceType = valueSourceType;
    }

    public ValuesSourceType valueSourceType() {
        return this.valueSourceType;
    }

    public FieldContext fieldContext() {
        return this.fieldContext;
    }

    public SearchScript.LeafFactory script() {
        return this.script;
    }

    public boolean unmapped() {
        return this.unmapped;
    }

    public boolean valid() {
        return this.fieldContext != null || this.script != null || this.unmapped;
    }

    public ValuesSourceConfig<VS> fieldContext(FieldContext fieldContext) {
        this.fieldContext = fieldContext;
        return this;
    }

    public ValuesSourceConfig<VS> script(SearchScript.LeafFactory script) {
        this.script = script;
        return this;
    }

    public ValuesSourceConfig<VS> scriptValueType(ValueType scriptValueType) {
        this.scriptValueType = scriptValueType;
        return this;
    }

    public ValueType scriptValueType() {
        return this.scriptValueType;
    }

    public ValuesSourceConfig<VS> unmapped(boolean unmapped) {
        this.unmapped = unmapped;
        return this;
    }

    public ValuesSourceConfig<VS> format(DocValueFormat format) {
        this.format = format;
        return this;
    }

    public ValuesSourceConfig<VS> missing(Object missing) {
        this.missing = missing;
        return this;
    }

    public Object missing() {
        return this.missing;
    }

    public ValuesSourceConfig<VS> timezone(DateTimeZone timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    public DateTimeZone timezone() {
        return this.timeZone;
    }

    public DocValueFormat format() {
        return this.format;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public VS toValuesSource(QueryShardContext context) throws IOException {
        Object vs;
        if (!this.valid()) {
            throw new IllegalStateException("value source config is invalid; must have either a field context or a script or marked as unwrapped");
        }
        if (this.unmapped()) {
            if (this.missing() == null) {
                vs = null;
            } else if (this.valueSourceType() == ValuesSourceType.NUMERIC) {
                vs = ValuesSource.Numeric.EMPTY;
            } else if (this.valueSourceType() == ValuesSourceType.GEOPOINT) {
                vs = ValuesSource.GeoPoint.EMPTY;
            } else {
                if (this.valueSourceType() != ValuesSourceType.ANY && this.valueSourceType() != ValuesSourceType.BYTES) throw new IllegalArgumentException("Can't deal with unmapped ValuesSource type " + (Object)((Object)this.valueSourceType()));
                vs = ValuesSource.Bytes.WithOrdinals.EMPTY;
            }
        } else {
            vs = this.originalValuesSource();
        }
        if (this.missing() == null) {
            return (VS)vs;
        }
        if (vs instanceof ValuesSource.Bytes) {
            BytesRef missing = this.format.parseBytesRef(this.missing().toString());
            if (!(vs instanceof ValuesSource.Bytes.WithOrdinals)) return (VS)MissingValues.replaceMissing((ValuesSource.Bytes)vs, missing);
            return (VS)MissingValues.replaceMissing((ValuesSource.Bytes.WithOrdinals)vs, missing);
        }
        if (vs instanceof ValuesSource.Numeric) {
            Double missing = this.format.parseDouble(this.missing().toString(), false, context::nowInMillis);
            return (VS)MissingValues.replaceMissing((ValuesSource.Numeric)vs, missing);
        }
        if (!(vs instanceof ValuesSource.GeoPoint)) throw new IllegalArgumentException("Can't apply missing values on a " + vs.getClass());
        GeoPoint missing = new GeoPoint(this.missing().toString());
        return (VS)MissingValues.replaceMissing((ValuesSource.GeoPoint)vs, missing);
    }

    private VS originalValuesSource() throws IOException {
        if (this.fieldContext() == null) {
            if (this.valueSourceType() == ValuesSourceType.NUMERIC) {
                return (VS)this.numericScript();
            }
            if (this.valueSourceType() == ValuesSourceType.BYTES) {
                return (VS)this.bytesScript();
            }
            throw new AggregationExecutionException("value source of type [" + this.valueSourceType().name() + "] is not supported by scripts");
        }
        if (this.valueSourceType() == ValuesSourceType.NUMERIC) {
            return (VS)this.numericField();
        }
        if (this.valueSourceType() == ValuesSourceType.GEOPOINT) {
            return (VS)this.geoPointField();
        }
        return (VS)this.bytesField();
    }

    private ValuesSource.Numeric numericScript() throws IOException {
        return new ValuesSource.Numeric.Script(this.script(), this.scriptValueType());
    }

    private ValuesSource.Numeric numericField() throws IOException {
        if (!(this.fieldContext().indexFieldData() instanceof IndexNumericFieldData)) {
            throw new IllegalArgumentException("Expected numeric type on field [" + this.fieldContext().field() + "], but got [" + this.fieldContext().fieldType().typeName() + "]");
        }
        ValuesSource.Numeric dataSource = new ValuesSource.Numeric.FieldData((IndexNumericFieldData)this.fieldContext().indexFieldData());
        if (this.script() != null) {
            dataSource = new ValuesSource.Numeric.WithScript(dataSource, this.script());
        }
        return dataSource;
    }

    private ValuesSource bytesField() throws IOException {
        IndexFieldData<?> indexFieldData = this.fieldContext().indexFieldData();
        ValuesSource.Bytes dataSource = indexFieldData instanceof IndexOrdinalsFieldData ? new ValuesSource.Bytes.WithOrdinals.FieldData((IndexOrdinalsFieldData)indexFieldData) : new ValuesSource.Bytes.FieldData(indexFieldData);
        if (this.script() != null) {
            dataSource = new ValuesSource.WithScript(dataSource, this.script());
        }
        return dataSource;
    }

    private ValuesSource.Bytes bytesScript() throws IOException {
        return new ValuesSource.Bytes.Script(this.script());
    }

    private ValuesSource.GeoPoint geoPointField() throws IOException {
        if (!(this.fieldContext().indexFieldData() instanceof IndexGeoPointFieldData)) {
            throw new IllegalArgumentException("Expected geo_point type on field [" + this.fieldContext().field() + "], but got [" + this.fieldContext().fieldType().typeName() + "]");
        }
        return new ValuesSource.GeoPoint.Fielddata((IndexGeoPointFieldData)this.fieldContext().indexFieldData());
    }
}

