/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.inject.Binder;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.inject.Module;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.logging.Loggers;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.ClusterSettings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.IndexScopedSettings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Setting;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.SettingsFilter;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentType;
import org.apache.logging.log4j.Logger;

public class SettingsModule
implements Module {
    private final Settings settings;
    private final Set<String> settingsFilterPattern = new HashSet<String>();
    private final Map<String, Setting<?>> nodeSettings = new HashMap();
    private final Map<String, Setting<?>> indexSettings = new HashMap();
    private final Logger logger;
    private final IndexScopedSettings indexScopedSettings;
    private final ClusterSettings clusterSettings;
    private final SettingsFilter settingsFilter;

    public SettingsModule(Settings settings, Setting<?> ... additionalSettings) {
        this(settings, Arrays.asList(additionalSettings), Collections.emptyList());
    }

    public SettingsModule(Settings settings, List<Setting<?>> additionalSettings, List<String> settingsFilter) {
        this.logger = Loggers.getLogger(this.getClass(), settings, new String[0]);
        this.settings = settings;
        for (Setting<?> setting : ClusterSettings.BUILT_IN_CLUSTER_SETTINGS) {
            this.registerSetting(setting);
        }
        for (Setting<?> setting : IndexScopedSettings.BUILT_IN_INDEX_SETTINGS) {
            this.registerSetting(setting);
        }
        for (Setting<?> setting : additionalSettings) {
            this.registerSetting(setting);
        }
        for (String filter : settingsFilter) {
            this.registerSettingsFilter(filter);
        }
        this.indexScopedSettings = new IndexScopedSettings(settings, new HashSet(this.indexSettings.values()));
        this.clusterSettings = new ClusterSettings(settings, new HashSet(this.nodeSettings.values()));
        Settings indexSettings = settings.filter(s -> s.startsWith("index.") && !"index.query.bool.max_clause_count".equals(s) && this.clusterSettings.get((String)s) == null);
        if (!indexSettings.isEmpty()) {
            try {
                String separator = IntStream.range(0, 85).mapToObj(s -> "*").collect(Collectors.joining("")).trim();
                StringBuilder builder = new StringBuilder();
                builder.append(System.lineSeparator());
                builder.append(separator);
                builder.append(System.lineSeparator());
                builder.append("Found index level settings on node level configuration.");
                builder.append(System.lineSeparator());
                builder.append(System.lineSeparator());
                int count = 0;
                for (String word : "Since elasticsearch 5.x index level settings can NOT be set on the nodes configuration like the elasticsearch.yaml, in system properties or command line arguments.In order to upgrade all indices the settings must be updated via the /${index}/_settings API. Unless all settings are dynamic all indices must be closed in order to apply the upgradeIndices created in the future should use index templates to set default values.".split(" ")) {
                    if (count + word.length() > 85) {
                        builder.append(System.lineSeparator());
                        count = 0;
                    }
                    count += word.length() + 1;
                    builder.append(word).append(" ");
                }
                builder.append(System.lineSeparator());
                builder.append(System.lineSeparator());
                builder.append("Please ensure all required values are updated on all indices by executing: ");
                builder.append(System.lineSeparator());
                builder.append(System.lineSeparator());
                builder.append("curl -XPUT 'http://localhost:9200/_all/_settings?preserve_existing=true' -d '");
                try (XContentBuilder xContentBuilder = XContentBuilder.builder(XContentType.JSON.xContent());){
                    xContentBuilder.prettyPrint();
                    xContentBuilder.startObject();
                    indexSettings.toXContent(xContentBuilder, new ToXContent.MapParams(Collections.singletonMap("flat_settings", "true")));
                    xContentBuilder.endObject();
                    builder.append(Strings.toString(xContentBuilder));
                }
                builder.append("'");
                builder.append(System.lineSeparator());
                builder.append(separator);
                builder.append(System.lineSeparator());
                this.logger.warn(builder.toString());
                throw new IllegalArgumentException("node settings must not contain any index level settings");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.clusterSettings.validate(settings, true);
        this.settingsFilter = new SettingsFilter(settings, this.settingsFilterPattern);
    }

    @Override
    public void configure(Binder binder) {
        binder.bind(Settings.class).toInstance(this.settings);
        binder.bind(SettingsFilter.class).toInstance(this.settingsFilter);
        binder.bind(ClusterSettings.class).toInstance(this.clusterSettings);
        binder.bind(IndexScopedSettings.class).toInstance(this.indexScopedSettings);
    }

    private void registerSetting(Setting<?> setting) {
        if (setting.isFiltered() && !this.settingsFilterPattern.contains(setting.getKey())) {
            this.registerSettingsFilter(setting.getKey());
        }
        if (setting.hasNodeScope() || setting.hasIndexScope()) {
            Setting<?> existingSetting;
            if (setting.hasNodeScope()) {
                existingSetting = this.nodeSettings.get(setting.getKey());
                if (existingSetting != null) {
                    throw new IllegalArgumentException("Cannot register setting [" + setting.getKey() + "] twice");
                }
                this.nodeSettings.put(setting.getKey(), setting);
            }
            if (setting.hasIndexScope()) {
                existingSetting = this.indexSettings.get(setting.getKey());
                if (existingSetting != null) {
                    throw new IllegalArgumentException("Cannot register setting [" + setting.getKey() + "] twice");
                }
                this.indexSettings.put(setting.getKey(), setting);
            }
        } else {
            throw new IllegalArgumentException("No scope found for setting [" + setting.getKey() + "]");
        }
    }

    private void registerSettingsFilter(String filter) {
        if (!SettingsFilter.isValidPattern(filter)) {
            throw new IllegalArgumentException("filter [" + filter + "] is invalid must be either a key or a regex pattern");
        }
        if (this.settingsFilterPattern.contains(filter)) {
            throw new IllegalArgumentException("filter [" + filter + "] has already been registered");
        }
        this.settingsFilterPattern.add(filter);
    }

    public Settings getSettings() {
        return this.settings;
    }

    public IndexScopedSettings getIndexScopedSettings() {
        return this.indexScopedSettings;
    }

    public ClusterSettings getClusterSettings() {
        return this.clusterSettings;
    }

    public SettingsFilter getSettingsFilter() {
        return this.settingsFilter;
    }
}

