/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.component;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.component.AbstractComponent;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.component.Lifecycle;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.component.LifecycleComponent;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.component.LifecycleListener;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Settings;

public abstract class AbstractLifecycleComponent
extends AbstractComponent
implements LifecycleComponent {
    protected final Lifecycle lifecycle = new Lifecycle();
    private final List<LifecycleListener> listeners = new CopyOnWriteArrayList<LifecycleListener>();

    protected AbstractLifecycleComponent(Settings settings) {
        super(settings);
    }

    protected AbstractLifecycleComponent(Settings settings, Class customClass) {
        super(settings, customClass);
    }

    @Override
    public Lifecycle.State lifecycleState() {
        return this.lifecycle.state();
    }

    @Override
    public void addLifecycleListener(LifecycleListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeLifecycleListener(LifecycleListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void start() {
        if (!this.lifecycle.canMoveToStarted()) {
            return;
        }
        for (LifecycleListener listener : this.listeners) {
            listener.beforeStart();
        }
        this.doStart();
        this.lifecycle.moveToStarted();
        for (LifecycleListener listener : this.listeners) {
            listener.afterStart();
        }
    }

    protected abstract void doStart();

    @Override
    public void stop() {
        if (!this.lifecycle.canMoveToStopped()) {
            return;
        }
        for (LifecycleListener listener : this.listeners) {
            listener.beforeStop();
        }
        this.lifecycle.moveToStopped();
        this.doStop();
        for (LifecycleListener listener : this.listeners) {
            listener.afterStop();
        }
    }

    protected abstract void doStop();

    @Override
    public void close() {
        if (this.lifecycle.started()) {
            this.stop();
        }
        if (!this.lifecycle.canMoveToClosed()) {
            return;
        }
        for (LifecycleListener listener : this.listeners) {
            listener.beforeClose();
        }
        this.lifecycle.moveToClosed();
        try {
            this.doClose();
        }
        catch (IOException e) {
            this.logger.warn("failed to close " + this.getClass().getName(), (Throwable)e);
        }
        for (LifecycleListener listener : this.listeners) {
            listener.afterClose();
        }
    }

    protected abstract void doClose() throws IOException;
}

