/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.fieldcaps;

import java.io.IOException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ActionRequestValidationException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.OriginalIndices;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.support.IndicesOptions;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.support.single.shard.SingleShardRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamOutput;

public class FieldCapabilitiesIndexRequest
extends SingleShardRequest<FieldCapabilitiesIndexRequest> {
    private String[] fields;
    private OriginalIndices originalIndices;

    FieldCapabilitiesIndexRequest() {
    }

    FieldCapabilitiesIndexRequest(String[] fields, String index, OriginalIndices originalIndices) {
        super(index);
        if (fields == null || fields.length == 0) {
            throw new IllegalArgumentException("specified fields can't be null or empty");
        }
        this.fields = fields;
        assert (index != null);
        this.index(index);
        this.originalIndices = originalIndices;
    }

    public String[] fields() {
        return this.fields;
    }

    @Override
    public String[] indices() {
        return this.originalIndices.indices();
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.originalIndices.indicesOptions();
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.fields = in.readStringArray();
        this.originalIndices = in.getVersion().onOrAfter(Version.V_6_2_0) ? OriginalIndices.readOriginalIndices(in) : OriginalIndices.NONE;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArray(this.fields);
        if (out.getVersion().onOrAfter(Version.V_6_2_0)) {
            OriginalIndices.writeOriginalIndices(this.originalIndices, out);
        }
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }
}

