/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.indices.create;

import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ActionListener;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.indices.create.CreateIndexClusterStateUpdateRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.support.ActionFilters;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.ClusterState;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.block.ClusterBlockException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.metadata.MetaDataCreateIndexService;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.service.ClusterService;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.inject.Inject;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.threadpool.ThreadPool;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.transport.TransportService;

public class TransportCreateIndexAction
extends TransportMasterNodeAction<CreateIndexRequest, CreateIndexResponse> {
    private final MetaDataCreateIndexService createIndexService;

    @Inject
    public TransportCreateIndexAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetaDataCreateIndexService createIndexService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, "indices:admin/create", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, CreateIndexRequest::new);
        this.createIndexService = createIndexService;
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected CreateIndexResponse newResponse() {
        return new CreateIndexResponse();
    }

    @Override
    protected ClusterBlockException checkBlock(CreateIndexRequest request, ClusterState state) {
        return state.blocks().indexBlockedException(ClusterBlockLevel.METADATA_WRITE, request.index());
    }

    @Override
    protected void masterOperation(CreateIndexRequest request, ClusterState state, ActionListener<CreateIndexResponse> listener) {
        String cause = request.cause();
        if (cause.length() == 0) {
            cause = "api";
        }
        String indexName = this.indexNameExpressionResolver.resolveDateMathExpression(request.index());
        CreateIndexClusterStateUpdateRequest updateRequest = ((CreateIndexClusterStateUpdateRequest)((CreateIndexClusterStateUpdateRequest)new CreateIndexClusterStateUpdateRequest(request, cause, indexName, request.index(), request.updateAllTypes()).ackTimeout(request.timeout())).masterNodeTimeout(request.masterNodeTimeout())).settings(request.settings()).mappings(request.mappings()).aliases(request.aliases()).customs(request.customs()).waitForActiveShards(request.waitForActiveShards());
        this.createIndexService.createIndex(updateRequest, ActionListener.wrap(response -> listener.onResponse(new CreateIndexResponse(response.isAcknowledged(), response.isShardsAcknowledged(), indexName)), listener::onFailure));
    }
}

