/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.delete.DeleteRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.index.IndexRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.update.UpdateRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentType;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSink;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.connectors.elasticsearch.ActionRequestFailureHandler;
import org.apache.flink.streaming.connectors.elasticsearch.ElasticsearchSinkFunction;
import org.apache.flink.streaming.connectors.elasticsearch.RequestIndexer;
import org.apache.flink.streaming.connectors.elasticsearch.index.IndexGenerator;
import org.apache.flink.streaming.connectors.elasticsearch.index.IndexGeneratorFactory;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.sinks.UpsertStreamTableSink;
import org.apache.flink.table.typeutils.TypeCheckUtils;
import org.apache.flink.table.utils.TableConnectorUtils;
import org.apache.flink.table.utils.TableSchemaUtils;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

@Internal
public abstract class ElasticsearchUpsertTableSinkBase
implements UpsertStreamTableSink<Row> {
    private final boolean isAppendOnly;
    private final TableSchema schema;
    private final List<Host> hosts;
    private final String index;
    private final String docType;
    private final String keyDelimiter;
    private final String keyNullLiteral;
    private final SerializationSchema<Row> serializationSchema;
    private final XContentType contentType;
    private final ActionRequestFailureHandler failureHandler;
    private final Map<SinkOption, String> sinkOptions;
    private final RequestFactory requestFactory;
    private int[] keyFieldIndices = new int[0];

    public ElasticsearchUpsertTableSinkBase(boolean isAppendOnly, TableSchema schema, List<Host> hosts, String index, String docType, String keyDelimiter, String keyNullLiteral, SerializationSchema<Row> serializationSchema, XContentType contentType, ActionRequestFailureHandler failureHandler, Map<SinkOption, String> sinkOptions, RequestFactory requestFactory) {
        this.isAppendOnly = isAppendOnly;
        this.schema = TableSchemaUtils.checkNoGeneratedColumns((TableSchema)schema);
        this.hosts = (List)Preconditions.checkNotNull(hosts);
        this.index = (String)Preconditions.checkNotNull((Object)index);
        this.keyDelimiter = (String)Preconditions.checkNotNull((Object)keyDelimiter);
        this.keyNullLiteral = (String)Preconditions.checkNotNull((Object)keyNullLiteral);
        this.docType = (String)Preconditions.checkNotNull((Object)docType);
        this.serializationSchema = (SerializationSchema)Preconditions.checkNotNull(serializationSchema);
        this.contentType = (XContentType)((Object)Preconditions.checkNotNull((Object)((Object)contentType)));
        this.failureHandler = (ActionRequestFailureHandler)Preconditions.checkNotNull((Object)failureHandler);
        this.sinkOptions = (Map)Preconditions.checkNotNull(sinkOptions);
        this.requestFactory = (RequestFactory)Preconditions.checkNotNull((Object)requestFactory);
    }

    public void setKeyFields(String[] keyNames) {
        if (keyNames == null) {
            this.keyFieldIndices = new int[0];
            return;
        }
        String[] fieldNames = this.getFieldNames();
        int[] keyFieldIndices = new int[keyNames.length];
        for (int i = 0; i < keyNames.length; ++i) {
            keyFieldIndices[i] = -1;
            for (int j = 0; j < fieldNames.length; ++j) {
                if (!keyNames[i].equals(fieldNames[j])) continue;
                keyFieldIndices[i] = j;
                break;
            }
            if (keyFieldIndices[i] != -1) continue;
            throw new RuntimeException("Invalid key fields: " + Arrays.toString(keyNames));
        }
        this.validateKeyTypes(keyFieldIndices);
        this.keyFieldIndices = keyFieldIndices;
    }

    public void setIsAppendOnly(Boolean isAppendOnly) {
        if (this.isAppendOnly && !isAppendOnly.booleanValue()) {
            throw new ValidationException("The given query is not supported by this sink because the sink is configured to operate in append mode only. Thus, it only support insertions (no queries with updating results).");
        }
    }

    public TypeInformation<Row> getRecordType() {
        return this.schema.toRowType();
    }

    public DataStreamSink<?> consumeDataStream(DataStream<Tuple2<Boolean, Row>> dataStream) {
        ElasticsearchUpsertSinkFunction upsertFunction = new ElasticsearchUpsertSinkFunction(IndexGeneratorFactory.createIndexGenerator(this.index, this.schema), this.docType, this.keyDelimiter, this.keyNullLiteral, this.serializationSchema, this.contentType, this.requestFactory, this.keyFieldIndices);
        SinkFunction<Tuple2<Boolean, Row>> sinkFunction = this.createSinkFunction(this.hosts, this.failureHandler, this.sinkOptions, upsertFunction);
        return dataStream.addSink(sinkFunction).setParallelism(dataStream.getParallelism()).name(TableConnectorUtils.generateRuntimeName(this.getClass(), (String[])this.getFieldNames()));
    }

    public TypeInformation<Tuple2<Boolean, Row>> getOutputType() {
        return Types.TUPLE((TypeInformation[])new TypeInformation[]{Types.BOOLEAN, this.getRecordType()});
    }

    public String[] getFieldNames() {
        return this.schema.getFieldNames();
    }

    public TypeInformation<?>[] getFieldTypes() {
        return this.schema.getFieldTypes();
    }

    public TableSink<Tuple2<Boolean, Row>> configure(String[] fieldNames, TypeInformation<?>[] fieldTypes) {
        if (!Arrays.equals(this.getFieldNames(), fieldNames) || !Arrays.equals(this.getFieldTypes(), fieldTypes)) {
            throw new ValidationException("Reconfiguration with different fields is not allowed. Expected: " + Arrays.toString(this.getFieldNames()) + " / " + Arrays.toString(this.getFieldTypes()) + ". But was: " + Arrays.toString(fieldNames) + " / " + Arrays.toString(fieldTypes));
        }
        return this.copy(this.isAppendOnly, this.schema, this.hosts, this.index, this.docType, this.keyDelimiter, this.keyNullLiteral, this.serializationSchema, this.contentType, this.failureHandler, this.sinkOptions, this.requestFactory);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ElasticsearchUpsertTableSinkBase that = (ElasticsearchUpsertTableSinkBase)o;
        return Objects.equals(this.isAppendOnly, that.isAppendOnly) && Objects.equals(this.schema, that.schema) && Objects.equals(this.hosts, that.hosts) && Objects.equals(this.index, that.index) && Objects.equals(this.docType, that.docType) && Objects.equals(this.keyDelimiter, that.keyDelimiter) && Objects.equals(this.keyNullLiteral, that.keyNullLiteral) && Objects.equals(this.serializationSchema, that.serializationSchema) && Objects.equals((Object)this.contentType, (Object)that.contentType) && Objects.equals(this.failureHandler, that.failureHandler) && Objects.equals(this.sinkOptions, that.sinkOptions);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.isAppendOnly, this.schema, this.hosts, this.index, this.docType, this.keyDelimiter, this.keyNullLiteral, this.serializationSchema, this.contentType, this.failureHandler, this.sinkOptions});
    }

    protected abstract ElasticsearchUpsertTableSinkBase copy(boolean var1, TableSchema var2, List<Host> var3, String var4, String var5, String var6, String var7, SerializationSchema<Row> var8, XContentType var9, ActionRequestFailureHandler var10, Map<SinkOption, String> var11, RequestFactory var12);

    protected abstract SinkFunction<Tuple2<Boolean, Row>> createSinkFunction(List<Host> var1, ActionRequestFailureHandler var2, Map<SinkOption, String> var3, ElasticsearchUpsertSinkFunction var4);

    private void validateKeyTypes(int[] keyFieldIndices) {
        TypeInformation<?>[] types = this.getFieldTypes();
        for (int keyFieldIndex : keyFieldIndices) {
            TypeInformation<?> type = types[keyFieldIndex];
            if (TypeCheckUtils.isSimpleStringRepresentation(type)) continue;
            throw new ValidationException("Only simple types that can be safely converted into a string representation can be used as keys. But was: " + type);
        }
    }

    public static class ElasticsearchUpsertSinkFunction
    implements ElasticsearchSinkFunction<Tuple2<Boolean, Row>> {
        private final IndexGenerator indexGenerator;
        private final String docType;
        private final String keyDelimiter;
        private final String keyNullLiteral;
        private final SerializationSchema<Row> serializationSchema;
        private final XContentType contentType;
        private final RequestFactory requestFactory;
        private final int[] keyFieldIndices;

        public ElasticsearchUpsertSinkFunction(IndexGenerator indexGenerator, String docType, String keyDelimiter, String keyNullLiteral, SerializationSchema<Row> serializationSchema, XContentType contentType, RequestFactory requestFactory, int[] keyFieldIndices) {
            this.indexGenerator = (IndexGenerator)Preconditions.checkNotNull((Object)indexGenerator);
            this.docType = (String)Preconditions.checkNotNull((Object)docType);
            this.keyDelimiter = (String)Preconditions.checkNotNull((Object)keyDelimiter);
            this.serializationSchema = (SerializationSchema)Preconditions.checkNotNull(serializationSchema);
            this.contentType = (XContentType)((Object)Preconditions.checkNotNull((Object)((Object)contentType)));
            this.keyFieldIndices = (int[])Preconditions.checkNotNull((Object)keyFieldIndices);
            this.requestFactory = (RequestFactory)Preconditions.checkNotNull((Object)requestFactory);
            this.keyNullLiteral = (String)Preconditions.checkNotNull((Object)keyNullLiteral);
        }

        @Override
        public void open() {
            this.indexGenerator.open();
        }

        @Override
        public void process(Tuple2<Boolean, Row> element, RuntimeContext ctx, RequestIndexer indexer) {
            String formattedIndex = this.indexGenerator.generate((Row)element.f1);
            if (((Boolean)element.f0).booleanValue()) {
                this.processUpsert((Row)element.f1, indexer, formattedIndex);
            } else {
                this.processDelete((Row)element.f1, indexer, formattedIndex);
            }
        }

        private void processUpsert(Row row, RequestIndexer indexer, String formattedIndex) {
            byte[] document = this.serializationSchema.serialize((Object)row);
            if (this.keyFieldIndices.length == 0) {
                IndexRequest indexRequest = this.requestFactory.createIndexRequest(formattedIndex, this.docType, this.contentType, document);
                indexer.add(indexRequest);
            } else {
                String key = this.createKey(row);
                UpdateRequest updateRequest = this.requestFactory.createUpdateRequest(formattedIndex, this.docType, key, this.contentType, document);
                indexer.add(updateRequest);
            }
        }

        private void processDelete(Row row, RequestIndexer indexer, String formattedIndex) {
            String key = this.createKey(row);
            DeleteRequest deleteRequest = this.requestFactory.createDeleteRequest(formattedIndex, this.docType, key);
            indexer.add(deleteRequest);
        }

        private String createKey(Row row) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < this.keyFieldIndices.length; ++i) {
                Object value;
                int keyFieldIndex = this.keyFieldIndices[i];
                if (i > 0) {
                    builder.append(this.keyDelimiter);
                }
                if ((value = row.getField(keyFieldIndex)) == null) {
                    builder.append(this.keyNullLiteral);
                    continue;
                }
                builder.append(value.toString());
            }
            return builder.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ElasticsearchUpsertSinkFunction that = (ElasticsearchUpsertSinkFunction)o;
            return Objects.equals(this.indexGenerator, that.indexGenerator) && Objects.equals(this.docType, that.docType) && Objects.equals(this.keyDelimiter, that.keyDelimiter) && Objects.equals(this.keyNullLiteral, that.keyNullLiteral) && Objects.equals(this.serializationSchema, that.serializationSchema) && this.contentType == that.contentType && Objects.equals(this.requestFactory, that.requestFactory) && Arrays.equals(this.keyFieldIndices, that.keyFieldIndices);
        }

        public int hashCode() {
            int result = Objects.hash(new Object[]{this.indexGenerator, this.docType, this.keyDelimiter, this.keyNullLiteral, this.serializationSchema, this.contentType, this.requestFactory});
            result = 31 * result + Arrays.hashCode(this.keyFieldIndices);
            return result;
        }
    }

    public static interface RequestFactory
    extends Serializable {
        public UpdateRequest createUpdateRequest(String var1, String var2, String var3, XContentType var4, byte[] var5);

        public IndexRequest createIndexRequest(String var1, String var2, XContentType var3, byte[] var4);

        public DeleteRequest createDeleteRequest(String var1, String var2, String var3);
    }

    public static class Host {
        public final String hostname;
        public final int port;
        public final String protocol;

        public Host(String hostname, int port, String protocol) {
            this.hostname = hostname;
            this.port = port;
            this.protocol = protocol;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Host host = (Host)o;
            return this.port == host.port && Objects.equals(this.hostname, host.hostname) && Objects.equals(this.protocol, host.protocol);
        }

        public int hashCode() {
            return Objects.hash(this.hostname, this.port, this.protocol);
        }

        public String toString() {
            return this.protocol + "://" + this.hostname + ":" + this.port;
        }
    }

    public static enum SinkOption {
        DISABLE_FLUSH_ON_CHECKPOINT,
        BULK_FLUSH_MAX_ACTIONS,
        BULK_FLUSH_MAX_SIZE,
        BULK_FLUSH_INTERVAL,
        BULK_FLUSH_BACKOFF_ENABLED,
        BULK_FLUSH_BACKOFF_TYPE,
        BULK_FLUSH_BACKOFF_RETRIES,
        BULK_FLUSH_BACKOFF_DELAY,
        REST_MAX_RETRY_TIMEOUT,
        REST_PATH_PREFIX;

    }
}

