/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.profile;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.Writeable;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ToXContentFragment;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentParserUtils;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.profile.ProfileShardResult;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.profile.Profilers;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.profile.aggregation.AggregationProfileShardResult;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.profile.aggregation.AggregationProfiler;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.profile.query.QueryProfileShardResult;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.profile.query.QueryProfiler;

public final class SearchProfileShardResults
implements Writeable,
ToXContentFragment {
    private static final String SEARCHES_FIELD = "searches";
    private static final String ID_FIELD = "id";
    private static final String SHARDS_FIELD = "shards";
    public static final String PROFILE_FIELD = "profile";
    private Map<String, ProfileShardResult> shardResults;

    public SearchProfileShardResults(Map<String, ProfileShardResult> shardResults) {
        this.shardResults = Collections.unmodifiableMap(shardResults);
    }

    public SearchProfileShardResults(StreamInput in) throws IOException {
        int size = in.readInt();
        this.shardResults = new HashMap<String, ProfileShardResult>(size);
        for (int i = 0; i < size; ++i) {
            String key = in.readString();
            ProfileShardResult shardResult = new ProfileShardResult(in);
            this.shardResults.put(key, shardResult);
        }
        this.shardResults = Collections.unmodifiableMap(this.shardResults);
    }

    public Map<String, ProfileShardResult> getShardResults() {
        return this.shardResults;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeInt(this.shardResults.size());
        for (Map.Entry<String, ProfileShardResult> entry : this.shardResults.entrySet()) {
            out.writeString(entry.getKey());
            entry.getValue().writeTo(out);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(PROFILE_FIELD).startArray(SHARDS_FIELD);
        TreeSet<String> sortedKeys = new TreeSet<String>(this.shardResults.keySet());
        for (String key : sortedKeys) {
            builder.startObject();
            builder.field(ID_FIELD, key);
            builder.startArray(SEARCHES_FIELD);
            ProfileShardResult profileShardResult = this.shardResults.get(key);
            for (QueryProfileShardResult result : profileShardResult.getQueryProfileResults()) {
                result.toXContent(builder, params);
            }
            builder.endArray();
            profileShardResult.getAggregationProfileResults().toXContent(builder, params);
            builder.endObject();
        }
        builder.endArray().endObject();
        return builder;
    }

    public static SearchProfileShardResults fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, token, parser::getTokenLocation);
        HashMap<String, ProfileShardResult> searchProfileResults = new HashMap<String, ProfileShardResult>();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.START_ARRAY) {
                if (SHARDS_FIELD.equals(parser.currentName())) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        SearchProfileShardResults.parseSearchProfileResultsEntry(parser, searchProfileResults);
                    }
                    continue;
                }
                parser.skipChildren();
                continue;
            }
            if (token != XContentParser.Token.START_OBJECT) continue;
            parser.skipChildren();
        }
        return new SearchProfileShardResults(searchProfileResults);
    }

    private static void parseSearchProfileResultsEntry(XContentParser parser, Map<String, ProfileShardResult> searchProfileResults) throws IOException {
        XContentParser.Token token = parser.currentToken();
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, token, parser::getTokenLocation);
        ArrayList<QueryProfileShardResult> queryProfileResults = new ArrayList<QueryProfileShardResult>();
        AggregationProfileShardResult aggProfileShardResult = null;
        String id = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if (ID_FIELD.equals(currentFieldName)) {
                    id = parser.text();
                    continue;
                }
                parser.skipChildren();
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (SEARCHES_FIELD.equals(currentFieldName)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        queryProfileResults.add(QueryProfileShardResult.fromXContent(parser));
                    }
                    continue;
                }
                if ("aggregations".equals(currentFieldName)) {
                    aggProfileShardResult = AggregationProfileShardResult.fromXContent(parser);
                    continue;
                }
                parser.skipChildren();
                continue;
            }
            parser.skipChildren();
        }
        searchProfileResults.put(id, new ProfileShardResult(queryProfileResults, aggProfileShardResult));
    }

    public static ProfileShardResult buildShardResults(Profilers profilers) {
        List<QueryProfiler> queryProfilers = profilers.getQueryProfilers();
        AggregationProfiler aggProfiler = profilers.getAggregationProfiler();
        ArrayList<QueryProfileShardResult> queryResults = new ArrayList<QueryProfileShardResult>(queryProfilers.size());
        for (QueryProfiler queryProfiler : queryProfilers) {
            QueryProfileShardResult result = new QueryProfileShardResult(queryProfiler.getTree(), queryProfiler.getRewriteTime(), queryProfiler.getCollector());
            queryResults.add(result);
        }
        AggregationProfileShardResult aggResults = new AggregationProfileShardResult(aggProfiler.getTree());
        return new ProfileShardResult(queryResults, aggResults);
    }
}

