/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.bucket.composite;

import java.io.IOException;
import java.util.function.LongUnaryOperator;
import java.util.function.ToLongFunction;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.document.IntPoint;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.document.LongPoint;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.IndexReader;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.SortedNumericDocValues;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.PointRangeQuery;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.Query;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.CheckedFunction;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.lease.Releasables;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.util.BigArrays;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.util.LongArray;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.mapper.DateFieldMapper;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.mapper.MappedFieldType;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.mapper.NumberFieldMapper;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.DocValueFormat;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.bucket.composite.PointsSortedDocsProducer;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.bucket.composite.SingleDimensionValuesSource;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.bucket.composite.SortedDocsProducer;

class LongValuesSource
extends SingleDimensionValuesSource<Long> {
    private final CheckedFunction<LeafReaderContext, SortedNumericDocValues, IOException> docValuesFunc;
    private final LongUnaryOperator rounding;
    private final LongArray values;
    private long currentValue;

    LongValuesSource(BigArrays bigArrays, MappedFieldType fieldType, CheckedFunction<LeafReaderContext, SortedNumericDocValues, IOException> docValuesFunc, LongUnaryOperator rounding, DocValueFormat format, Object missing, int size, int reverseMul) {
        super(format, fieldType, missing, size, reverseMul);
        this.docValuesFunc = docValuesFunc;
        this.rounding = rounding;
        this.values = bigArrays.newLongArray(size, false);
    }

    @Override
    void copyCurrent(int slot) {
        this.values.set(slot, this.currentValue);
    }

    @Override
    int compare(int from, int to) {
        return this.compareValues(this.values.get(from), this.values.get(to));
    }

    @Override
    int compareCurrent(int slot) {
        return this.compareValues(this.currentValue, this.values.get(slot));
    }

    @Override
    int compareCurrentWithAfter() {
        return this.compareValues(this.currentValue, (Long)this.afterValue);
    }

    private int compareValues(long v1, long v2) {
        return Long.compare(v1, v2) * this.reverseMul;
    }

    @Override
    void setAfter(Comparable<?> value) {
        this.afterValue = value instanceof Number ? Long.valueOf(((Number)((Object)value)).longValue()) : Long.valueOf(this.format.parseLong(value.toString(), false, () -> {
            throw new IllegalArgumentException("now() is not supported in [after] key");
        }));
    }

    @Override
    Long toComparable(int slot) {
        return this.values.get(slot);
    }

    @Override
    LeafBucketCollector getLeafCollector(LeafReaderContext context, final LeafBucketCollector next) throws IOException {
        final SortedNumericDocValues dvs = this.docValuesFunc.apply(context);
        return new LeafBucketCollector(){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                if (dvs.advanceExact(doc)) {
                    int num = dvs.docValueCount();
                    for (int i = 0; i < num; ++i) {
                        LongValuesSource.this.currentValue = dvs.nextValue();
                        next.collect(doc, bucket);
                    }
                }
            }
        };
    }

    @Override
    LeafBucketCollector getLeafCollector(Comparable<?> value, LeafReaderContext context, final LeafBucketCollector next) {
        if (value.getClass() != Long.class) {
            throw new IllegalArgumentException("Expected Long, got " + value.getClass());
        }
        this.currentValue = (Long)value;
        return new LeafBucketCollector(){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                next.collect(doc, bucket);
            }
        };
    }

    @Override
    SortedDocsProducer createSortedDocsProducerOrNull(IndexReader reader, Query query) {
        byte[] upperPoint;
        byte[] lowerPoint;
        if (!this.checkIfSortedDocsIsApplicable(reader, this.fieldType) || query != null && query.getClass() != MatchAllDocsQuery.class && !(query instanceof PointRangeQuery && this.fieldType.name().equals(((PointRangeQuery)query).getField()))) {
            return null;
        }
        if (query instanceof PointRangeQuery) {
            PointRangeQuery rangeQuery = (PointRangeQuery)query;
            lowerPoint = rangeQuery.getLowerPoint();
            upperPoint = rangeQuery.getUpperPoint();
        } else {
            lowerPoint = null;
            upperPoint = null;
        }
        if (this.fieldType instanceof NumberFieldMapper.NumberFieldType) {
            ToLongFunction<byte[]> toBucketFunction;
            NumberFieldMapper.NumberFieldType ft = (NumberFieldMapper.NumberFieldType)this.fieldType;
            switch (ft.typeName()) {
                case "long": {
                    toBucketFunction = value -> this.rounding.applyAsLong(LongPoint.decodeDimension(value, 0));
                    break;
                }
                case "int": 
                case "short": 
                case "byte": {
                    toBucketFunction = value -> this.rounding.applyAsLong(IntPoint.decodeDimension(value, 0));
                    break;
                }
                default: {
                    return null;
                }
            }
            return new PointsSortedDocsProducer(this.fieldType.name(), toBucketFunction, lowerPoint, upperPoint);
        }
        if (this.fieldType instanceof DateFieldMapper.DateFieldType) {
            ToLongFunction<byte[]> toBucketFunction = value -> this.rounding.applyAsLong(LongPoint.decodeDimension(value, 0));
            return new PointsSortedDocsProducer(this.fieldType.name(), toBucketFunction, lowerPoint, upperPoint);
        }
        return null;
    }

    @Override
    public void close() {
        Releasables.close(this.values);
    }
}

