/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.action.admin.indices;

import java.io.IOException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.indices.close.CloseIndexRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.indices.close.CloseIndexResponse;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.support.IndicesOptions;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.node.NodeClient;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.BaseRestHandler;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.RestChannel;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.RestController;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.RestRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.action.RestToXContentListener;

public class RestCloseIndexAction
extends BaseRestHandler {
    public RestCloseIndexAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.POST, "/_close", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_close", this);
    }

    @Override
    public String getName() {
        return "close_index_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        CloseIndexRequest closeIndexRequest = new CloseIndexRequest(Strings.splitStringByCommaToArray(request.param("index")));
        closeIndexRequest.masterNodeTimeout(request.paramAsTime("master_timeout", closeIndexRequest.masterNodeTimeout()));
        closeIndexRequest.timeout(request.paramAsTime("timeout", closeIndexRequest.timeout()));
        closeIndexRequest.indicesOptions(IndicesOptions.fromRequest(request, closeIndexRequest.indicesOptions()));
        return channel -> client.admin().indices().close(closeIndexRequest, new RestToXContentListener<CloseIndexResponse>((RestChannel)channel));
    }
}

