/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.snapshots;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public class IndexShardSnapshotStatus {
    private final AtomicReference<Stage> stage;
    private long startTime;
    private long totalTime;
    private int numberOfFiles;
    private int processedFiles;
    private long totalSize;
    private long processedSize;
    private long indexVersion;
    private String failure;

    private IndexShardSnapshotStatus(Stage stage, long startTime, long totalTime, int numberOfFiles, int processedFiles, long totalSize, long processedSize, long indexVersion, String failure) {
        this.stage = new AtomicReference<Stage>(Objects.requireNonNull(stage));
        this.startTime = startTime;
        this.totalTime = totalTime;
        this.numberOfFiles = numberOfFiles;
        this.processedFiles = processedFiles;
        this.totalSize = totalSize;
        this.processedSize = processedSize;
        this.indexVersion = indexVersion;
        this.failure = failure;
    }

    public synchronized Copy moveToStarted(long startTime, int numberOfFiles, long totalSize) {
        if (!this.stage.compareAndSet(Stage.INIT, Stage.STARTED)) {
            throw new IllegalStateException("Unable to move the shard snapshot status to [STARTED]: expecting [INIT] but got [" + (Object)((Object)this.stage.get()) + "]");
        }
        this.startTime = startTime;
        this.numberOfFiles = numberOfFiles;
        this.totalSize = totalSize;
        return this.asCopy();
    }

    public synchronized Copy moveToFinalize(long indexVersion) {
        if (!this.stage.compareAndSet(Stage.STARTED, Stage.FINALIZE)) {
            throw new IllegalStateException("Unable to move the shard snapshot status to [FINALIZE]: expecting [STARTED] but got [" + (Object)((Object)this.stage.get()) + "]");
        }
        this.indexVersion = indexVersion;
        return this.asCopy();
    }

    public synchronized Copy moveToDone(long endTime) {
        if (!this.stage.compareAndSet(Stage.FINALIZE, Stage.DONE)) {
            throw new IllegalStateException("Unable to move the shard snapshot status to [DONE]: expecting [FINALIZE] but got [" + (Object)((Object)this.stage.get()) + "]");
        }
        this.totalTime = Math.max(0L, endTime - this.startTime);
        return this.asCopy();
    }

    public synchronized Copy abortIfNotCompleted(String failure) {
        if (this.stage.compareAndSet(Stage.INIT, Stage.ABORTED) || this.stage.compareAndSet(Stage.STARTED, Stage.ABORTED)) {
            this.failure = failure;
        }
        return this.asCopy();
    }

    public synchronized void moveToFailed(long endTime, String failure) {
        if (this.stage.getAndSet(Stage.FAILURE) != Stage.FAILURE) {
            this.totalTime = Math.max(0L, endTime - this.startTime);
            this.failure = failure;
        }
    }

    public boolean isAborted() {
        return this.stage.get() == Stage.ABORTED;
    }

    public synchronized void addProcessedFile(long size) {
        ++this.processedFiles;
        this.processedSize += size;
    }

    public synchronized Copy asCopy() {
        return new Copy(this.stage.get(), this.startTime, this.totalTime, this.numberOfFiles, this.processedFiles, this.totalSize, this.processedSize, this.indexVersion, this.failure);
    }

    public static IndexShardSnapshotStatus newInitializing() {
        return new IndexShardSnapshotStatus(Stage.INIT, 0L, 0L, 0, 0, 0L, 0L, 0L, null);
    }

    public static IndexShardSnapshotStatus newFailed(String failure) {
        assert (failure != null) : "expecting non null failure for a failed IndexShardSnapshotStatus";
        if (failure == null) {
            throw new IllegalArgumentException("A failure description is required for a failed IndexShardSnapshotStatus");
        }
        return new IndexShardSnapshotStatus(Stage.FAILURE, 0L, 0L, 0, 0, 0L, 0L, 0L, failure);
    }

    public static IndexShardSnapshotStatus newDone(long startTime, long totalTime, int files, long size) {
        return new IndexShardSnapshotStatus(Stage.DONE, startTime, totalTime, files, files, size, size, 0L, null);
    }

    public static class Copy {
        private final Stage stage;
        private final long startTime;
        private final long totalTime;
        private final int numberOfFiles;
        private final int processedFiles;
        private final long totalSize;
        private final long processedSize;
        private final long indexVersion;
        private final String failure;

        public Copy(Stage stage, long startTime, long totalTime, int numberOfFiles, int processedFiles, long totalSize, long processedSize, long indexVersion, String failure) {
            this.stage = stage;
            this.startTime = startTime;
            this.totalTime = totalTime;
            this.numberOfFiles = numberOfFiles;
            this.processedFiles = processedFiles;
            this.totalSize = totalSize;
            this.processedSize = processedSize;
            this.indexVersion = indexVersion;
            this.failure = failure;
        }

        public Stage getStage() {
            return this.stage;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public long getTotalTime() {
            return this.totalTime;
        }

        public int getNumberOfFiles() {
            return this.numberOfFiles;
        }

        public int getProcessedFiles() {
            return this.processedFiles;
        }

        public long getTotalSize() {
            return this.totalSize;
        }

        public long getProcessedSize() {
            return this.processedSize;
        }

        public long getIndexVersion() {
            return this.indexVersion;
        }

        public String getFailure() {
            return this.failure;
        }

        public String toString() {
            return "index shard snapshot status (stage=" + (Object)((Object)this.stage) + ", startTime=" + this.startTime + ", totalTime=" + this.totalTime + ", numberOfFiles=" + this.numberOfFiles + ", processedFiles=" + this.processedFiles + ", totalSize=" + this.totalSize + ", processedSize=" + this.processedSize + ", indexVersion=" + this.indexVersion + ", failure='" + this.failure + '\'' + ')';
        }
    }

    public static enum Stage {
        INIT,
        STARTED,
        FINALIZE,
        DONE,
        FAILURE,
        ABORTED;

    }
}

