/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.geo.builders;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.Assertions;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.geo.GeoShapeType;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.geo.parsers.ShapeParser;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.NamedWriteable;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.logging.ESLoggerFactory;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ToXContentObject;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.logging.log4j.Logger;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.spatial4j.context.jts.JtsSpatialContext;
import org.locationtech.spatial4j.exception.InvalidShapeException;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.jts.JtsGeometry;

public abstract class ShapeBuilder<T extends Shape, E extends ShapeBuilder<T, E>>
implements NamedWriteable,
ToXContentObject {
    protected static final Logger LOGGER = ESLoggerFactory.getLogger(ShapeBuilder.class.getName());
    private static final boolean DEBUG = Assertions.ENABLED;
    protected final List<Coordinate> coordinates;
    public static final double DATELINE = 180.0;
    public static final Coordinate ZERO_ZERO = new Coordinate(0.0, 0.0);
    public static final JtsSpatialContext SPATIAL_CONTEXT = JtsSpatialContext.GEO;
    public static final GeometryFactory FACTORY = SPATIAL_CONTEXT.getGeometryFactory();
    protected final boolean wrapdateline = SPATIAL_CONTEXT.isGeo();
    protected static final boolean MULTI_POLYGON_MAY_OVERLAP = false;
    protected static final boolean AUTO_VALIDATE_JTS_GEOMETRY = true;
    protected static final boolean AUTO_INDEX_JTS_GEOMETRY = true;
    protected static final IntersectionOrder INTERSECTION_ORDER = new IntersectionOrder();

    protected ShapeBuilder() {
        this.coordinates = new ArrayList<Coordinate>();
    }

    protected ShapeBuilder(List<Coordinate> coordinates) {
        if (coordinates == null || coordinates.size() == 0) {
            throw new IllegalArgumentException("cannot create point collection with empty set of points");
        }
        this.coordinates = coordinates;
    }

    protected ShapeBuilder(StreamInput in) throws IOException {
        int size = in.readVInt();
        this.coordinates = new ArrayList<Coordinate>(size);
        for (int i = 0; i < size; ++i) {
            this.coordinates.add(ShapeBuilder.readFromStream(in));
        }
    }

    protected static Coordinate readFromStream(StreamInput in) throws IOException {
        double x = in.readDouble();
        double y = in.readDouble();
        Double z = null;
        if (in.getVersion().onOrAfter(Version.V_6_3_0)) {
            z = in.readOptionalDouble();
        }
        return z == null ? new Coordinate(x, y) : new Coordinate(x, y, z.doubleValue());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.coordinates.size());
        for (Coordinate point : this.coordinates) {
            ShapeBuilder.writeCoordinateTo(point, out);
        }
    }

    protected static void writeCoordinateTo(Coordinate coordinate, StreamOutput out) throws IOException {
        out.writeDouble(coordinate.x);
        out.writeDouble(coordinate.y);
        if (out.getVersion().onOrAfter(Version.V_6_3_0)) {
            out.writeOptionalDouble(Double.isNaN(coordinate.z) ? null : Double.valueOf(coordinate.z));
        }
    }

    private E thisRef() {
        return (E)this;
    }

    public E coordinate(double longitude, double latitude) {
        return this.coordinate(new Coordinate(longitude, latitude));
    }

    public E coordinate(Coordinate coordinate) {
        this.coordinates.add(coordinate);
        return this.thisRef();
    }

    public E coordinates(Coordinate ... coordinates) {
        return this.coordinates(Arrays.asList(coordinates));
    }

    public E coordinates(Collection<? extends Coordinate> coordinates) {
        this.coordinates.addAll(coordinates);
        return this.thisRef();
    }

    protected Coordinate[] coordinates(boolean closed) {
        Coordinate[] result = this.coordinates.toArray(new Coordinate[this.coordinates.size() + (closed ? 1 : 0)]);
        if (closed) {
            result[result.length - 1] = result[0];
        }
        return result;
    }

    protected JtsGeometry jtsGeometry(Geometry geom) {
        JtsGeometry jtsGeometry = new JtsGeometry(geom, SPATIAL_CONTEXT, false, false);
        jtsGeometry.validate();
        jtsGeometry.index();
        return jtsGeometry;
    }

    public abstract T build();

    protected static Coordinate shift(Coordinate coordinate, double dateline) {
        if (dateline == 0.0) {
            return coordinate;
        }
        return new Coordinate(-2.0 * dateline + coordinate.x, coordinate.y);
    }

    public abstract GeoShapeType type();

    public abstract int numDimensions();

    protected static final double intersection(Coordinate p1, Coordinate p2, double dateline) {
        if (p1.x == p2.x && p1.x != dateline) {
            return Double.NaN;
        }
        if (p1.x == p2.x && p1.x == dateline) {
            return 1.0;
        }
        double t = (dateline - p1.x) / (p2.x - p1.x);
        if (t > 1.0 || t <= 0.0) {
            return Double.NaN;
        }
        return t;
    }

    protected static int intersections(double dateline, Edge[] edges) {
        int numIntersections = 0;
        assert (!Double.isNaN(dateline));
        for (int i = 0; i < edges.length; ++i) {
            Coordinate p1 = edges[i].coordinate;
            Coordinate p2 = edges[i].next.coordinate;
            assert (!Double.isNaN(p2.x) && !Double.isNaN(p1.x));
            edges[i].intersect = Edge.MAX_COORDINATE;
            double position = ShapeBuilder.intersection(p1, p2, dateline);
            if (Double.isNaN(position)) continue;
            edges[i].intersection(position);
            ++numIntersections;
        }
        Arrays.sort(edges, INTERSECTION_ORDER);
        return numIntersections;
    }

    protected StringBuilder contentToWKT() {
        return ShapeBuilder.coordinateListToWKT(this.coordinates);
    }

    public String toWKT() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.type().wktName());
        sb.append(" ");
        sb.append((CharSequence)this.contentToWKT());
        return sb.toString();
    }

    protected static StringBuilder coordinateListToWKT(List<Coordinate> coordinates) {
        StringBuilder sb = new StringBuilder();
        if (coordinates.isEmpty()) {
            sb.append("EMPTY");
        } else {
            sb.append("(");
            sb.append(ShapeBuilder.coordinateToWKT(coordinates.get(0)));
            for (int i = 1; i < coordinates.size(); ++i) {
                sb.append(",");
                sb.append(" ");
                sb.append(ShapeBuilder.coordinateToWKT(coordinates.get(i)));
            }
            sb.append(")");
        }
        return sb;
    }

    private static String coordinateToWKT(Coordinate coordinate) {
        StringBuilder sb = new StringBuilder();
        sb.append(coordinate.x + " " + coordinate.y);
        if (!Double.isNaN(coordinate.z)) {
            sb.append(" " + coordinate.z);
        }
        return sb.toString();
    }

    protected static final boolean debugEnabled() {
        return LOGGER.isDebugEnabled() || DEBUG;
    }

    @Deprecated
    public static ShapeBuilder parse(XContentParser parser) throws IOException {
        return ShapeParser.parse(parser);
    }

    protected static XContentBuilder toXContent(XContentBuilder builder, Coordinate coordinate) throws IOException {
        builder.startArray().value(coordinate.x).value(coordinate.y);
        if (!Double.isNaN(coordinate.z)) {
            builder.value(coordinate.z);
        }
        return builder.endArray();
    }

    protected XContentBuilder coordinatesToXcontent(XContentBuilder builder, boolean closed) throws IOException {
        builder.startArray();
        for (Coordinate coord : this.coordinates) {
            ShapeBuilder.toXContent(builder, coord);
        }
        if (closed) {
            Coordinate start = this.coordinates.get(0);
            Coordinate end = this.coordinates.get(this.coordinates.size() - 1);
            if (start.x != end.x || start.y != end.y) {
                ShapeBuilder.toXContent(builder, this.coordinates.get(0));
            }
        }
        builder.endArray();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ShapeBuilder)) {
            return false;
        }
        ShapeBuilder that = (ShapeBuilder)o;
        return Objects.equals(this.coordinates, that.coordinates);
    }

    public int hashCode() {
        return Objects.hash(this.coordinates);
    }

    @Override
    public String getWriteableName() {
        return this.type().shapeName();
    }

    public String toString() {
        return Strings.toString(this, true, true);
    }

    public static enum Orientation {
        LEFT,
        RIGHT;

        public static final Orientation CLOCKWISE;
        public static final Orientation COUNTER_CLOCKWISE;
        public static final Orientation CW;
        public static final Orientation CCW;

        public void writeTo(StreamOutput out) throws IOException {
            out.writeBoolean(this == RIGHT);
        }

        public static Orientation readFrom(StreamInput in) throws IOException {
            return in.readBoolean() ? RIGHT : LEFT;
        }

        public static Orientation fromString(String orientation) {
            switch (orientation = orientation.toLowerCase(Locale.ROOT)) {
                case "right": 
                case "counterclockwise": 
                case "ccw": {
                    return RIGHT;
                }
                case "left": 
                case "clockwise": 
                case "cw": {
                    return LEFT;
                }
            }
            throw new IllegalArgumentException("Unknown orientation [" + orientation + "]");
        }

        static {
            CLOCKWISE = LEFT;
            COUNTER_CLOCKWISE = RIGHT;
            CW = LEFT;
            CCW = RIGHT;
        }
    }

    private static final class IntersectionOrder
    implements Comparator<Edge> {
        private IntersectionOrder() {
        }

        @Override
        public int compare(Edge o1, Edge o2) {
            return Double.compare(o1.intersect.y, o2.intersect.y);
        }
    }

    protected static final class Edge {
        Coordinate coordinate;
        Edge next;
        Coordinate intersect;
        int component = -1;
        public static final Coordinate MAX_COORDINATE = new Coordinate(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);

        protected Edge(Coordinate coordinate, Edge next, Coordinate intersection) {
            this.coordinate = coordinate;
            this.setNext(next);
            this.intersect = intersection;
            if (next != null) {
                this.component = next.component;
            }
        }

        protected Edge(Coordinate coordinate, Edge next) {
            this(coordinate, next, MAX_COORDINATE);
        }

        protected void setNext(Edge next) {
            if (next != null) {
                if (this.coordinate.equals((Object)next.coordinate)) {
                    throw new InvalidShapeException("Provided shape has duplicate consecutive coordinates at: " + this.coordinate);
                }
                this.next = next;
            }
        }

        protected Coordinate intersection(double position) {
            this.intersect = Edge.position(this.coordinate, this.next.coordinate, position);
            return this.intersect;
        }

        protected static Coordinate position(Coordinate p1, Coordinate p2, double position) {
            if (position == 0.0) {
                return p1;
            }
            if (position == 1.0) {
                return p2;
            }
            double x = p1.x + position * (p2.x - p1.x);
            double y = p1.y + position * (p2.y - p1.y);
            return new Coordinate(x, y);
        }

        public String toString() {
            return "Edge[Component=" + this.component + "; start=" + this.coordinate + " ; intersection=" + this.intersect + "]";
        }
    }
}

