/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.cluster.repositories.get;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ActionResponse;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.metadata.RepositoryMetaData;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Settings;

public class GetRepositoriesResponse
extends ActionResponse
implements Iterable<RepositoryMetaData> {
    private List<RepositoryMetaData> repositories = Collections.emptyList();

    GetRepositoriesResponse() {
    }

    GetRepositoriesResponse(List<RepositoryMetaData> repositories) {
        this.repositories = repositories;
    }

    public List<RepositoryMetaData> repositories() {
        return this.repositories;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        int size = in.readVInt();
        ArrayList<RepositoryMetaData> repositoryListBuilder = new ArrayList<RepositoryMetaData>(size);
        for (int j = 0; j < size; ++j) {
            repositoryListBuilder.add(new RepositoryMetaData(in.readString(), in.readString(), Settings.readSettingsFromStream(in)));
        }
        this.repositories = Collections.unmodifiableList(repositoryListBuilder);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.repositories.size());
        for (RepositoryMetaData repository : this.repositories) {
            out.writeString(repository.name());
            out.writeString(repository.type());
            Settings.writeSettingsToStream(repository.settings(), out);
        }
    }

    @Override
    public Iterator<RepositoryMetaData> iterator() {
        return this.repositories.iterator();
    }
}

