/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial3d.geom;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial3d.geom.BaseXYZSolid;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial3d.geom.GeoPoint;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial3d.geom.GeoShape;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial3d.geom.Plane;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial3d.geom.PlanetModel;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial3d.geom.SerializableObject;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial3d.geom.SidedPlane;

class XdYZSolid
extends BaseXYZSolid {
    protected final double minX;
    protected final double maxX;
    protected final double Y;
    protected final double minZ;
    protected final double maxZ;
    protected final SidedPlane minXPlane;
    protected final SidedPlane maxXPlane;
    protected final Plane yPlane;
    protected final SidedPlane minZPlane;
    protected final SidedPlane maxZPlane;
    protected final GeoPoint[] edgePoints;
    protected final GeoPoint[] notableYPoints;

    public XdYZSolid(PlanetModel planetModel, double minX, double maxX, double Y, double minZ, double maxZ) {
        super(planetModel);
        GeoPoint intPoint;
        if (maxX - minX < 1.0E-12) {
            throw new IllegalArgumentException("X values in wrong order or identical");
        }
        if (maxZ - minZ < 1.0E-12) {
            throw new IllegalArgumentException("Z values in wrong order or identical");
        }
        this.minX = minX;
        this.maxX = maxX;
        this.Y = Y;
        this.minZ = minZ;
        this.maxZ = maxZ;
        double worldMinY = planetModel.getMinimumYValue();
        double worldMaxY = planetModel.getMaximumYValue();
        this.minXPlane = new SidedPlane(maxX, 0.0, 0.0, xUnitVector, -minX);
        this.maxXPlane = new SidedPlane(minX, 0.0, 0.0, xUnitVector, -maxX);
        this.yPlane = new Plane(yUnitVector, -Y);
        this.minZPlane = new SidedPlane(0.0, 0.0, maxZ, zUnitVector, -minZ);
        this.maxZPlane = new SidedPlane(0.0, 0.0, minZ, zUnitVector, -maxZ);
        GeoPoint[] minXY = this.minXPlane.findIntersections(planetModel, this.yPlane, this.maxXPlane, this.minZPlane, this.maxZPlane);
        GeoPoint[] maxXY = this.maxXPlane.findIntersections(planetModel, this.yPlane, this.minXPlane, this.minZPlane, this.maxZPlane);
        GeoPoint[] YminZ = this.yPlane.findIntersections(planetModel, (Plane)this.minZPlane, this.maxZPlane, this.minXPlane, this.maxXPlane);
        GeoPoint[] YmaxZ = this.yPlane.findIntersections(planetModel, (Plane)this.maxZPlane, this.minZPlane, this.minXPlane, this.maxXPlane);
        this.notableYPoints = XdYZSolid.glueTogether(minXY, maxXY, YminZ, YmaxZ);
        boolean minXYminZ = planetModel.pointOutside(minX, Y, minZ);
        boolean minXYmaxZ = planetModel.pointOutside(minX, Y, maxZ);
        boolean maxXYminZ = planetModel.pointOutside(maxX, Y, minZ);
        boolean maxXYmaxZ = planetModel.pointOutside(maxX, Y, maxZ);
        GeoPoint[] yEdges = Y - worldMinY >= -1.0E-12 && Y - worldMaxY <= 1.0E-12 && minX < 0.0 && maxX > 0.0 && minZ < 0.0 && maxZ > 0.0 && minXYminZ && minXYmaxZ && maxXYminZ && maxXYmaxZ ? ((intPoint = this.yPlane.getSampleIntersectionPoint(planetModel, yVerticalPlane)) != null ? new GeoPoint[]{intPoint} : EMPTY_POINTS) : EMPTY_POINTS;
        this.edgePoints = XdYZSolid.glueTogether(minXY, maxXY, YminZ, YmaxZ, yEdges);
    }

    public XdYZSolid(PlanetModel planetModel, InputStream inputStream) throws IOException {
        this(planetModel, SerializableObject.readDouble(inputStream), SerializableObject.readDouble(inputStream), SerializableObject.readDouble(inputStream), SerializableObject.readDouble(inputStream), SerializableObject.readDouble(inputStream));
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        SerializableObject.writeDouble(outputStream, this.minX);
        SerializableObject.writeDouble(outputStream, this.maxX);
        SerializableObject.writeDouble(outputStream, this.Y);
        SerializableObject.writeDouble(outputStream, this.minZ);
        SerializableObject.writeDouble(outputStream, this.maxZ);
    }

    @Override
    protected GeoPoint[] getEdgePoints() {
        return this.edgePoints;
    }

    @Override
    public boolean isWithin(double x, double y, double z) {
        return this.minXPlane.isWithin(x, y, z) && this.maxXPlane.isWithin(x, y, z) && this.yPlane.evaluateIsZero(x, y, z) && this.minZPlane.isWithin(x, y, z) && this.maxZPlane.isWithin(x, y, z);
    }

    @Override
    public int getRelationship(GeoShape path) {
        int insideRectangle = this.isShapeInsideArea(path);
        if (insideRectangle == 1) {
            return 2;
        }
        int insideShape = this.isAreaInsideShape(path);
        if (insideShape == 1) {
            return 2;
        }
        if (insideRectangle == 0 && insideShape == 0) {
            return 2;
        }
        if (path.intersects(this.yPlane, this.notableYPoints, this.minXPlane, this.maxXPlane, this.minZPlane, this.maxZPlane)) {
            return 2;
        }
        if (insideRectangle == 0) {
            return 1;
        }
        if (insideShape == 0) {
            return 0;
        }
        return 3;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof XdYZSolid)) {
            return false;
        }
        XdYZSolid other = (XdYZSolid)o;
        if (!super.equals(other)) {
            return false;
        }
        return other.minXPlane.equals(this.minXPlane) && other.maxXPlane.equals(this.maxXPlane) && other.yPlane.equals(this.yPlane) && other.minZPlane.equals(this.minZPlane) && other.maxZPlane.equals(this.maxZPlane);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.minXPlane.hashCode();
        result = 31 * result + this.maxXPlane.hashCode();
        result = 31 * result + this.yPlane.hashCode();
        result = 31 * result + this.minZPlane.hashCode();
        result = 31 * result + this.maxZPlane.hashCode();
        return result;
    }

    public String toString() {
        return "XdYZSolid: {planetmodel=" + this.planetModel + ", minXplane=" + this.minXPlane + ", maxXplane=" + this.maxXPlane + ", yplane=" + this.yPlane + ", minZplane=" + this.minZPlane + ", maxZplane=" + this.maxZPlane + "}";
    }
}

