/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial.prefix;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.IndexReaderContext;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.DoubleValuesSource;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial.prefix.PrefixTreeFacetCounter;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial.prefix.PrefixTreeStrategy;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial.prefix.RecursivePrefixTreeStrategy;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial.prefix.tree.Cell;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial.prefix.tree.NumberRangePrefixTree;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.Bits;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Shape;

public class NumberRangePrefixTreeStrategy
extends RecursivePrefixTreeStrategy {
    public NumberRangePrefixTreeStrategy(NumberRangePrefixTree prefixTree, String fieldName) {
        super(prefixTree, fieldName);
        this.setPruneLeafyBranches(false);
        this.setPrefixGridScanLevel(prefixTree.getMaxLevels() - 2);
        this.setPointsOnly(false);
        this.setDistErrPct(0.0);
    }

    @Override
    public NumberRangePrefixTree getGrid() {
        return (NumberRangePrefixTree)super.getGrid();
    }

    @Override
    protected boolean isPointShape(Shape shape) {
        if (shape instanceof NumberRangePrefixTree.UnitNRShape) {
            return ((NumberRangePrefixTree.UnitNRShape)shape).getLevel() == this.grid.getMaxLevels();
        }
        return false;
    }

    @Override
    protected boolean isGridAlignedShape(Shape shape) {
        if (shape instanceof NumberRangePrefixTree.UnitNRShape) {
            return ((NumberRangePrefixTree.UnitNRShape)shape).getLevel() > 0;
        }
        return false;
    }

    @Override
    public DoubleValuesSource makeDistanceValueSource(Point queryPoint, double multiplier) {
        throw new UnsupportedOperationException();
    }

    public Facets calcFacets(IndexReaderContext context, Bits topAcceptDocs, NumberRangePrefixTree.UnitNRShape start, NumberRangePrefixTree.UnitNRShape end) throws IOException {
        NumberRangePrefixTree.NRShape facetRange = this.getGrid().toRangeShape(start, end);
        int detailLevel = Math.max(start.getLevel(), end.getLevel()) + 1;
        return this.calcFacets(context, topAcceptDocs, facetRange, detailLevel);
    }

    public Facets calcFacets(IndexReaderContext context, Bits topAcceptDocs, Shape facetRange, final int level) throws IOException {
        final Facets facets = new Facets(level);
        PrefixTreeFacetCounter.compute((PrefixTreeStrategy)this, context, topAcceptDocs, facetRange, level, new PrefixTreeFacetCounter.FacetVisitor(){
            Facets.FacetParentVal parentFacet;
            NumberRangePrefixTree.UnitNRShape parentShape;

            @Override
            public void visit(Cell cell, int count) {
                if (cell.getLevel() < level - 1) {
                    this.parentFacet = null;
                    this.parentShape = null;
                    facets.topLeaves += count;
                } else if (cell.getLevel() == level - 1) {
                    this.setupParent((NumberRangePrefixTree.UnitNRShape)cell.getShape());
                    this.parentFacet.parentLeaves += count;
                } else {
                    NumberRangePrefixTree.UnitNRShape unitShape = (NumberRangePrefixTree.UnitNRShape)cell.getShape();
                    NumberRangePrefixTree.UnitNRShape unitShapeParent = unitShape.getShapeAtLevel(unitShape.getLevel() - 1);
                    if (this.parentFacet == null || !this.parentShape.equals(unitShapeParent)) {
                        this.setupParent(unitShapeParent);
                    }
                    if (this.parentFacet.childCounts == null) {
                        this.parentFacet.childCounts = new int[this.parentFacet.childCountsLen];
                    }
                    int n = unitShape.getValAtLevel(cell.getLevel());
                    this.parentFacet.childCounts[n] = this.parentFacet.childCounts[n] + count;
                }
            }

            private void setupParent(NumberRangePrefixTree.UnitNRShape unitShape) {
                this.parentShape = unitShape.clone();
                this.parentFacet = (Facets.FacetParentVal)facets.parents.get(this.parentShape);
                if (this.parentFacet == null) {
                    this.parentFacet = new Facets.FacetParentVal();
                    this.parentFacet.childCountsLen = NumberRangePrefixTreeStrategy.this.getGrid().getNumSubCells(this.parentShape);
                    facets.parents.put(this.parentShape, this.parentFacet);
                }
            }
        });
        return facets;
    }

    public static class Facets {
        public final int detailLevel;
        public int topLeaves;
        public final SortedMap<NumberRangePrefixTree.UnitNRShape, FacetParentVal> parents = new TreeMap<NumberRangePrefixTree.UnitNRShape, FacetParentVal>();

        public Facets(int detailLevel) {
            this.detailLevel = detailLevel;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(2048);
            buf.append("Facets: level=" + this.detailLevel + " topLeaves=" + this.topLeaves + " parentCount=" + this.parents.size());
            for (Map.Entry<NumberRangePrefixTree.UnitNRShape, FacetParentVal> entry : this.parents.entrySet()) {
                buf.append('\n');
                if (buf.length() > 1000) {
                    buf.append("...");
                    break;
                }
                FacetParentVal pVal = entry.getValue();
                buf.append(' ').append(entry.getKey() + " leafCount=" + pVal.parentLeaves);
                if (pVal.childCounts == null) continue;
                buf.append(' ').append(Arrays.toString(pVal.childCounts));
            }
            return buf.toString();
        }

        public static class FacetParentVal {
            public int parentLeaves;
            public int childCountsLen;
            public int[] childCounts;
        }
    }
}

