/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.DirectoryReader;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.IndexCommit;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.IndexReader;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.IndexWriter;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.LeafReader;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.ReadersAndUpdates;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.SegmentCommitInfo;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.SegmentInfos;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.SegmentReader;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.store.AlreadyClosedException;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.store.Directory;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.store.IOContext;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.IOUtils;

public final class StandardDirectoryReader
extends DirectoryReader {
    final IndexWriter writer;
    final SegmentInfos segmentInfos;
    private final boolean applyAllDeletes;
    private final boolean writeAllDeletes;
    private final Set<IndexReader.ClosedListener> readerClosedListeners = new CopyOnWriteArraySet<IndexReader.ClosedListener>();
    private final IndexReader.CacheHelper cacheHelper = new IndexReader.CacheHelper(){
        private final IndexReader.CacheKey cacheKey = new IndexReader.CacheKey();

        @Override
        public IndexReader.CacheKey getKey() {
            return this.cacheKey;
        }

        @Override
        public void addClosedListener(IndexReader.ClosedListener listener) {
            StandardDirectoryReader.this.ensureOpen();
            StandardDirectoryReader.this.readerClosedListeners.add(listener);
        }
    };

    StandardDirectoryReader(Directory directory, LeafReader[] readers, IndexWriter writer, SegmentInfos sis, boolean applyAllDeletes, boolean writeAllDeletes) throws IOException {
        super(directory, readers);
        this.writer = writer;
        this.segmentInfos = sis;
        this.applyAllDeletes = applyAllDeletes;
        this.writeAllDeletes = writeAllDeletes;
    }

    static DirectoryReader open(Directory directory, IndexCommit commit) throws IOException {
        return (DirectoryReader)new SegmentInfos.FindSegmentsFile<DirectoryReader>(directory){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected DirectoryReader doBody(String segmentFileName) throws IOException {
                SegmentInfos sis = SegmentInfos.readCommit(this.directory, segmentFileName);
                Closeable[] readers = new SegmentReader[sis.size()];
                boolean success = false;
                try {
                    for (int i = sis.size() - 1; i >= 0; --i) {
                        readers[i] = new SegmentReader(sis.info(i), sis.getIndexCreatedVersionMajor(), IOContext.READ);
                    }
                    StandardDirectoryReader reader = new StandardDirectoryReader(this.directory, (LeafReader[])readers, null, sis, false, false);
                    success = true;
                    StandardDirectoryReader standardDirectoryReader = reader;
                    return standardDirectoryReader;
                }
                finally {
                    if (!success) {
                        IOUtils.closeWhileHandlingException(readers);
                    }
                }
            }
        }.run(commit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DirectoryReader open(IndexWriter writer, SegmentInfos infos, boolean applyAllDeletes, boolean writeAllDeletes) throws IOException {
        int numSegments = infos.size();
        ArrayList<SegmentReader> readers = new ArrayList<SegmentReader>(numSegments);
        Directory dir = writer.getDirectory();
        SegmentInfos segmentInfos = infos.clone();
        int infosUpto = 0;
        boolean success = false;
        try {
            for (int i = 0; i < numSegments; ++i) {
                SegmentCommitInfo info = infos.info(i);
                assert (info.info.dir == dir);
                ReadersAndUpdates rld = writer.readerPool.get(info, true);
                try {
                    SegmentReader reader = rld.getReadOnlyClone(IOContext.READ);
                    if (reader.numDocs() > 0 || writer.getKeepFullyDeletedSegments()) {
                        readers.add(reader);
                        ++infosUpto;
                        continue;
                    }
                    reader.decRef();
                    segmentInfos.remove(infosUpto);
                    continue;
                }
                finally {
                    writer.readerPool.release(rld);
                }
            }
            writer.incRefDeleter(segmentInfos);
            StandardDirectoryReader result = new StandardDirectoryReader(dir, readers.toArray(new SegmentReader[readers.size()]), writer, segmentInfos, applyAllDeletes, writeAllDeletes);
            success = true;
            StandardDirectoryReader standardDirectoryReader = result;
            return standardDirectoryReader;
        }
        finally {
            if (!success) {
                for (SegmentReader r : readers) {
                    try {
                        r.decRef();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DirectoryReader open(Directory directory, SegmentInfos infos, List<? extends LeafReader> oldReaders) throws IOException {
        HashMap<String, Integer> segmentReaders;
        HashMap<String, Integer> hashMap = segmentReaders = oldReaders == null ? Collections.emptyMap() : new HashMap<String, Integer>(oldReaders.size());
        if (oldReaders != null) {
            int c = oldReaders.size();
            for (int i = 0; i < c; ++i) {
                SegmentReader sr = (SegmentReader)oldReaders.get(i);
                segmentReaders.put(sr.getSegmentName(), i);
            }
        }
        LeafReader[] newReaders = new SegmentReader[infos.size()];
        for (int i = infos.size() - 1; i >= 0; --i) {
            SegmentCommitInfo commitInfo = infos.info(i);
            Integer oldReaderIndex = (Integer)segmentReaders.get(commitInfo.info.name);
            SegmentReader oldReader = oldReaderIndex == null ? null : (SegmentReader)oldReaders.get(oldReaderIndex);
            if (oldReader != null && !Arrays.equals(commitInfo.info.getId(), oldReader.getSegmentInfo().info.getId())) {
                throw new IllegalStateException("same segment " + commitInfo.info.name + " has invalid doc count change; likely you are re-opening a reader after illegally removing index files yourself and building a new index in their place.  Use IndexWriter.deleteAll or open a new IndexWriter using OpenMode.CREATE instead");
            }
            boolean success = false;
            try {
                if (oldReader == null || commitInfo.info.getUseCompoundFile() != oldReader.getSegmentInfo().info.getUseCompoundFile()) {
                    SegmentReader newReader = new SegmentReader(commitInfo, infos.getIndexCreatedVersionMajor(), IOContext.READ);
                    newReaders[i] = newReader;
                } else if (oldReader.isNRT) {
                    newReaders[i] = new SegmentReader(commitInfo, oldReader);
                } else if (oldReader.getSegmentInfo().getDelGen() == commitInfo.getDelGen() && oldReader.getSegmentInfo().getFieldInfosGen() == commitInfo.getFieldInfosGen()) {
                    oldReader.incRef();
                    newReaders[i] = oldReader;
                } else {
                    assert (commitInfo.info.dir == oldReader.getSegmentInfo().info.dir);
                    newReaders[i] = oldReader.getSegmentInfo().getDelGen() == commitInfo.getDelGen() ? new SegmentReader(commitInfo, oldReader, oldReader.getLiveDocs(), oldReader.numDocs()) : new SegmentReader(commitInfo, oldReader);
                }
                success = true;
                continue;
            }
            finally {
                if (!success) {
                    StandardDirectoryReader.decRefWhileHandlingException((SegmentReader[])newReaders);
                }
            }
        }
        return new StandardDirectoryReader(directory, newReaders, null, infos, false, false);
    }

    private static void decRefWhileHandlingException(SegmentReader[] readers) {
        for (SegmentReader reader : readers) {
            if (reader == null) continue;
            try {
                reader.decRef();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getClass().getSimpleName());
        buffer.append('(');
        String segmentsFile = this.segmentInfos.getSegmentsFileName();
        if (segmentsFile != null) {
            buffer.append(segmentsFile).append(":").append(this.segmentInfos.getVersion());
        }
        if (this.writer != null) {
            buffer.append(":nrt");
        }
        for (LeafReader r : this.getSequentialSubReaders()) {
            buffer.append(' ');
            buffer.append(r);
        }
        buffer.append(')');
        return buffer.toString();
    }

    @Override
    protected DirectoryReader doOpenIfChanged() throws IOException {
        return this.doOpenIfChanged((IndexCommit)null);
    }

    @Override
    protected DirectoryReader doOpenIfChanged(IndexCommit commit) throws IOException {
        this.ensureOpen();
        if (this.writer != null) {
            return this.doOpenFromWriter(commit);
        }
        return this.doOpenNoWriter(commit);
    }

    @Override
    protected DirectoryReader doOpenIfChanged(IndexWriter writer, boolean applyAllDeletes) throws IOException {
        this.ensureOpen();
        if (writer == this.writer && applyAllDeletes == this.applyAllDeletes) {
            return this.doOpenFromWriter(null);
        }
        return writer.getReader(applyAllDeletes, this.writeAllDeletes);
    }

    private DirectoryReader doOpenFromWriter(IndexCommit commit) throws IOException {
        if (commit != null) {
            return this.doOpenFromCommit(commit);
        }
        if (this.writer.nrtIsCurrent(this.segmentInfos)) {
            return null;
        }
        DirectoryReader reader = this.writer.getReader(this.applyAllDeletes, this.writeAllDeletes);
        if (reader.getVersion() == this.segmentInfos.getVersion()) {
            reader.decRef();
            return null;
        }
        return reader;
    }

    private DirectoryReader doOpenNoWriter(IndexCommit commit) throws IOException {
        if (commit == null) {
            if (this.isCurrent()) {
                return null;
            }
        } else {
            if (this.directory != commit.getDirectory()) {
                throw new IOException("the specified commit does not match the specified Directory");
            }
            if (this.segmentInfos != null && commit.getSegmentsFileName().equals(this.segmentInfos.getSegmentsFileName())) {
                return null;
            }
        }
        return this.doOpenFromCommit(commit);
    }

    private DirectoryReader doOpenFromCommit(IndexCommit commit) throws IOException {
        return (DirectoryReader)new SegmentInfos.FindSegmentsFile<DirectoryReader>(this.directory){

            @Override
            protected DirectoryReader doBody(String segmentFileName) throws IOException {
                SegmentInfos infos = SegmentInfos.readCommit(this.directory, segmentFileName);
                return StandardDirectoryReader.this.doOpenIfChanged(infos);
            }
        }.run(commit);
    }

    DirectoryReader doOpenIfChanged(SegmentInfos infos) throws IOException {
        return StandardDirectoryReader.open(this.directory, infos, this.getSequentialSubReaders());
    }

    @Override
    public long getVersion() {
        this.ensureOpen();
        return this.segmentInfos.getVersion();
    }

    public SegmentInfos getSegmentInfos() {
        return this.segmentInfos;
    }

    @Override
    public boolean isCurrent() throws IOException {
        this.ensureOpen();
        if (this.writer == null || this.writer.isClosed()) {
            SegmentInfos sis = SegmentInfos.readLatestCommit(this.directory);
            return sis.getVersion() == this.segmentInfos.getVersion();
        }
        return this.writer.nrtIsCurrent(this.segmentInfos);
    }

    @Override
    protected void doClose() throws IOException {
        Throwable firstExc = null;
        for (LeafReader r : this.getSequentialSubReaders()) {
            try {
                r.decRef();
            }
            catch (Throwable t) {
                if (firstExc != null) continue;
                firstExc = t;
            }
        }
        if (this.writer != null) {
            try {
                this.writer.decRefDeleter(this.segmentInfos);
            }
            catch (AlreadyClosedException alreadyClosedException) {
                // empty catch block
            }
        }
        if (firstExc != null) {
            throw IOUtils.rethrowAlways(firstExc);
        }
    }

    @Override
    public IndexCommit getIndexCommit() throws IOException {
        this.ensureOpen();
        return new ReaderCommit(this, this.segmentInfos, this.directory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void notifyReaderClosedListeners(Throwable th) throws IOException {
        Set<IndexReader.ClosedListener> set = this.readerClosedListeners;
        synchronized (set) {
            for (IndexReader.ClosedListener listener : this.readerClosedListeners) {
                try {
                    listener.onClose(this.cacheHelper.getKey());
                }
                catch (Throwable t) {
                    if (th == null) {
                        th = t;
                        continue;
                    }
                    th.addSuppressed(t);
                }
            }
            if (th != null) {
                throw IOUtils.rethrowAlways(th);
            }
        }
    }

    @Override
    public IndexReader.CacheHelper getReaderCacheHelper() {
        return this.cacheHelper;
    }

    static final class ReaderCommit
    extends IndexCommit {
        private String segmentsFileName;
        Collection<String> files;
        Directory dir;
        long generation;
        final Map<String, String> userData;
        private final int segmentCount;
        private final StandardDirectoryReader reader;

        ReaderCommit(StandardDirectoryReader reader, SegmentInfos infos, Directory dir) throws IOException {
            this.segmentsFileName = infos.getSegmentsFileName();
            this.dir = dir;
            this.userData = infos.getUserData();
            this.files = Collections.unmodifiableCollection(infos.files(true));
            this.generation = infos.getGeneration();
            this.segmentCount = infos.size();
            this.reader = reader;
        }

        public String toString() {
            return "StandardDirectoryReader.ReaderCommit(" + this.segmentsFileName + " files=" + this.files + ")";
        }

        @Override
        public int getSegmentCount() {
            return this.segmentCount;
        }

        @Override
        public String getSegmentsFileName() {
            return this.segmentsFileName;
        }

        @Override
        public Collection<String> getFileNames() {
            return this.files;
        }

        @Override
        public Directory getDirectory() {
            return this.dir;
        }

        @Override
        public long getGeneration() {
            return this.generation;
        }

        @Override
        public boolean isDeleted() {
            return false;
        }

        @Override
        public Map<String, String> getUserData() {
            return this.userData;
        }

        @Override
        public void delete() {
            throw new UnsupportedOperationException("This IndexCommit does not support deletions");
        }

        @Override
        StandardDirectoryReader getReader() {
            return this.reader;
        }
    }
}

