/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch.table;

import java.time.ZoneId;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.elasticsearch6.shaded.org.apache.http.HttpHost;
import org.apache.flink.elasticsearch6.shaded.org.apache.http.auth.AuthScope;
import org.apache.flink.elasticsearch6.shaded.org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.flink.elasticsearch6.shaded.org.apache.http.client.CredentialsProvider;
import org.apache.flink.elasticsearch6.shaded.org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.delete.DeleteRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.index.IndexRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.update.UpdateRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.RestClientBuilder;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentType;
import org.apache.flink.streaming.connectors.elasticsearch.table.Elasticsearch6Configuration;
import org.apache.flink.streaming.connectors.elasticsearch.table.IndexGeneratorFactory;
import org.apache.flink.streaming.connectors.elasticsearch.table.KeyExtractor;
import org.apache.flink.streaming.connectors.elasticsearch.table.RequestFactory;
import org.apache.flink.streaming.connectors.elasticsearch.table.RowElasticsearchSinkFunction;
import org.apache.flink.streaming.connectors.elasticsearch6.ElasticsearchSink;
import org.apache.flink.streaming.connectors.elasticsearch6.RestClientFactory;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.format.EncodingFormat;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.sink.SinkFunctionProvider;
import org.apache.flink.table.data.RowData;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.StringUtils;

@Deprecated
@PublicEvolving
final class Elasticsearch6DynamicSink
implements DynamicTableSink {
    @VisibleForTesting
    static final Elasticsearch6RequestFactory REQUEST_FACTORY = new Elasticsearch6RequestFactory();
    private final EncodingFormat<SerializationSchema<RowData>> format;
    private final TableSchema schema;
    private final Elasticsearch6Configuration config;
    private final ZoneId localTimeZoneId;
    private final boolean isDynamicIndexWithSystemTime;
    private final ElasticSearchBuilderProvider builderProvider;

    public Elasticsearch6DynamicSink(EncodingFormat<SerializationSchema<RowData>> format, Elasticsearch6Configuration config, TableSchema schema, ZoneId localTimeZoneId) {
        this(format, config, schema, localTimeZoneId, ElasticsearchSink.Builder::new);
    }

    Elasticsearch6DynamicSink(EncodingFormat<SerializationSchema<RowData>> format, Elasticsearch6Configuration config, TableSchema schema, ZoneId localTimeZoneId, ElasticSearchBuilderProvider builderProvider) {
        this.format = format;
        this.schema = schema;
        this.config = config;
        this.localTimeZoneId = localTimeZoneId;
        this.isDynamicIndexWithSystemTime = this.isDynamicIndexWithSystemTime();
        this.builderProvider = builderProvider;
    }

    public boolean isDynamicIndexWithSystemTime() {
        IndexGeneratorFactory.IndexHelper indexHelper = new IndexGeneratorFactory.IndexHelper();
        return indexHelper.checkIsDynamicIndexWithSystemTimeFormat(this.config.getIndex());
    }

    public ChangelogMode getChangelogMode(ChangelogMode requestedMode) {
        ChangelogMode.Builder builder = ChangelogMode.newBuilder();
        for (RowKind kind : requestedMode.getContainedKinds()) {
            if (kind == RowKind.UPDATE_BEFORE) continue;
            builder.addContainedKind(kind);
        }
        if (this.isDynamicIndexWithSystemTime && !requestedMode.containsOnly(RowKind.INSERT)) {
            throw new ValidationException("Dynamic indexing based on system time only works on append only stream.");
        }
        return builder.build();
    }

    public SinkFunctionProvider getSinkRuntimeProvider(DynamicTableSink.Context context) {
        return () -> {
            SerializationSchema format = (SerializationSchema)this.format.createRuntimeEncoder(context, this.schema.toRowDataType());
            RowElasticsearchSinkFunction upsertFunction = new RowElasticsearchSinkFunction(IndexGeneratorFactory.createIndexGenerator(this.config.getIndex(), this.schema, this.localTimeZoneId), this.config.getDocumentType(), (SerializationSchema<RowData>)format, XContentType.JSON, REQUEST_FACTORY, KeyExtractor.createKeyExtractor(this.schema, this.config.getKeyDelimiter()));
            ElasticsearchSink.Builder<RowData> builder = this.builderProvider.createBuilder(this.config.getHosts(), upsertFunction);
            builder.setFailureHandler(this.config.getFailureHandler());
            builder.setBulkFlushMaxActions(this.config.getBulkFlushMaxActions());
            builder.setBulkFlushMaxSizeMb((int)(this.config.getBulkFlushMaxByteSize() >> 20));
            builder.setBulkFlushInterval(this.config.getBulkFlushInterval());
            builder.setBulkFlushBackoff(this.config.isBulkFlushBackoffEnabled());
            this.config.getBulkFlushBackoffType().ifPresent(builder::setBulkFlushBackoffType);
            this.config.getBulkFlushBackoffRetries().ifPresent(builder::setBulkFlushBackoffRetries);
            this.config.getBulkFlushBackoffDelay().ifPresent(builder::setBulkFlushBackoffDelay);
            if (this.config.getUsername().isPresent() && this.config.getPassword().isPresent() && !StringUtils.isNullOrWhitespaceOnly((String)this.config.getUsername().get()) && !StringUtils.isNullOrWhitespaceOnly((String)this.config.getPassword().get())) {
                builder.setRestClientFactory(new AuthRestClientFactory(this.config.getPathPrefix().orElse(null), this.config.getUsername().get(), this.config.getPassword().get()));
            } else {
                builder.setRestClientFactory(new DefaultRestClientFactory(this.config.getPathPrefix().orElse(null)));
            }
            ElasticsearchSink<RowData> sink = builder.build();
            if (this.config.isDisableFlushOnCheckpoint()) {
                sink.disableFlushOnCheckpoint();
            }
            return sink;
        };
    }

    public DynamicTableSink copy() {
        return this;
    }

    public String asSummaryString() {
        return "Elasticsearch6";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Elasticsearch6DynamicSink that = (Elasticsearch6DynamicSink)o;
        return Objects.equals(this.format, that.format) && Objects.equals(this.schema, that.schema) && Objects.equals(this.config, that.config) && Objects.equals(this.builderProvider, that.builderProvider);
    }

    public int hashCode() {
        return Objects.hash(this.format, this.schema, this.config, this.builderProvider);
    }

    private static class Elasticsearch6RequestFactory
    implements RequestFactory {
        private Elasticsearch6RequestFactory() {
        }

        @Override
        public UpdateRequest createUpdateRequest(String index, String docType, String key, XContentType contentType, byte[] document) {
            return new UpdateRequest(index, docType, key).doc(document, contentType).upsert(document, contentType);
        }

        @Override
        public IndexRequest createIndexRequest(String index, String docType, String key, XContentType contentType, byte[] document) {
            return new IndexRequest(index, docType, key).source(document, contentType);
        }

        @Override
        public DeleteRequest createDeleteRequest(String index, String docType, String key) {
            return new DeleteRequest(index, docType, key);
        }
    }

    @VisibleForTesting
    static class AuthRestClientFactory
    implements RestClientFactory {
        private final String pathPrefix;
        private final String username;
        private final String password;
        private transient CredentialsProvider credentialsProvider;

        public AuthRestClientFactory(@Nullable String pathPrefix, String username, String password) {
            this.pathPrefix = pathPrefix;
            this.password = password;
            this.username = username;
        }

        @Override
        public void configureRestClientBuilder(RestClientBuilder restClientBuilder) {
            if (this.pathPrefix != null) {
                restClientBuilder.setPathPrefix(this.pathPrefix);
            }
            if (this.credentialsProvider == null) {
                this.credentialsProvider = new BasicCredentialsProvider();
                this.credentialsProvider.setCredentials(AuthScope.ANY, new UsernamePasswordCredentials(this.username, this.password));
            }
            restClientBuilder.setHttpClientConfigCallback(httpAsyncClientBuilder -> httpAsyncClientBuilder.setDefaultCredentialsProvider(this.credentialsProvider));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AuthRestClientFactory that = (AuthRestClientFactory)o;
            return Objects.equals(this.pathPrefix, that.pathPrefix) && Objects.equals(this.username, that.username) && Objects.equals(this.password, that.password);
        }

        public int hashCode() {
            return Objects.hash(this.pathPrefix, this.username, this.password);
        }
    }

    @VisibleForTesting
    static class DefaultRestClientFactory
    implements RestClientFactory {
        private final String pathPrefix;

        public DefaultRestClientFactory(@Nullable String pathPrefix) {
            this.pathPrefix = pathPrefix;
        }

        @Override
        public void configureRestClientBuilder(RestClientBuilder restClientBuilder) {
            if (this.pathPrefix != null) {
                restClientBuilder.setPathPrefix(this.pathPrefix);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DefaultRestClientFactory that = (DefaultRestClientFactory)o;
            return Objects.equals(this.pathPrefix, that.pathPrefix);
        }

        public int hashCode() {
            return Objects.hash(this.pathPrefix);
        }
    }

    @FunctionalInterface
    static interface ElasticSearchBuilderProvider {
        public ElasticsearchSink.Builder<RowData> createBuilder(List<HttpHost> var1, RowElasticsearchSinkFunction var2);
    }
}

