/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.bucket.histogram;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.Aggregator;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.AggregatorFactories;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.AggregatorFactory;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.BucketOrder;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.bucket.histogram.HistogramAggregator;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.support.ValuesSource;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.internal.SearchContext;

public final class HistogramAggregatorFactory
extends ValuesSourceAggregatorFactory<ValuesSource.Numeric, HistogramAggregatorFactory> {
    private final double interval;
    private final double offset;
    private final BucketOrder order;
    private final boolean keyed;
    private final long minDocCount;
    private final double minBound;
    private final double maxBound;

    public HistogramAggregatorFactory(String name, ValuesSourceConfig<ValuesSource.Numeric> config, double interval, double offset, BucketOrder order, boolean keyed, long minDocCount, double minBound, double maxBound, SearchContext context, AggregatorFactory<?> parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metaData) throws IOException {
        super(name, config, context, parent, subFactoriesBuilder, metaData);
        this.interval = interval;
        this.offset = offset;
        this.order = order;
        this.keyed = keyed;
        this.minDocCount = minDocCount;
        this.minBound = minBound;
        this.maxBound = maxBound;
    }

    public long minDocCount() {
        return this.minDocCount;
    }

    @Override
    protected Aggregator doCreateInternal(ValuesSource.Numeric valuesSource, Aggregator parent, boolean collectsFromSingleBucket, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        if (!collectsFromSingleBucket) {
            return HistogramAggregatorFactory.asMultiBucketAggregator(this, this.context, parent);
        }
        return this.createAggregator(valuesSource, parent, pipelineAggregators, metaData);
    }

    private Aggregator createAggregator(ValuesSource.Numeric valuesSource, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        return new HistogramAggregator(this.name, this.factories, this.interval, this.offset, this.order, this.keyed, this.minDocCount, this.minBound, this.maxBound, valuesSource, this.config.format(), this.context, parent, pipelineAggregators, metaData);
    }

    @Override
    protected Aggregator createUnmapped(Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        return this.createAggregator(null, parent, pipelineAggregators, metaData);
    }
}

