/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.Streamable;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.Aggregation;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.Aggregations;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.InternalAggregation;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.pipeline.SiblingPipelineAggregator;

public final class InternalAggregations
extends Aggregations
implements Streamable {
    public static final InternalAggregations EMPTY = new InternalAggregations();
    private static final Comparator<InternalAggregation> INTERNAL_AGG_COMPARATOR = (agg1, agg2) -> {
        if (agg1.isMapped() == agg2.isMapped()) {
            return 0;
        }
        if (agg1.isMapped() && !agg2.isMapped()) {
            return -1;
        }
        return 1;
    };
    private List<SiblingPipelineAggregator> topLevelPipelineAggregators = Collections.emptyList();

    private InternalAggregations() {
    }

    public InternalAggregations(List<InternalAggregation> aggregations) {
        super(aggregations);
    }

    public InternalAggregations(List<InternalAggregation> aggregations, List<SiblingPipelineAggregator> topLevelPipelineAggregators) {
        super(aggregations);
        this.topLevelPipelineAggregators = Objects.requireNonNull(topLevelPipelineAggregators);
    }

    List<SiblingPipelineAggregator> getTopLevelPipelineAggregators() {
        return this.topLevelPipelineAggregators;
    }

    public static InternalAggregations reduce(List<InternalAggregations> aggregationsList, InternalAggregation.ReduceContext context) {
        if (aggregationsList.isEmpty()) {
            return null;
        }
        InternalAggregations first = aggregationsList.get(0);
        return InternalAggregations.reduce(aggregationsList, first.topLevelPipelineAggregators, context);
    }

    public static InternalAggregations reduce(List<InternalAggregations> aggregationsList, List<SiblingPipelineAggregator> topLevelPipelineAggregators, InternalAggregation.ReduceContext context) {
        if (aggregationsList.isEmpty()) {
            return null;
        }
        HashMap<String, List> aggByName = new HashMap<String, List>();
        for (InternalAggregations aggregations : aggregationsList) {
            for (Aggregation aggregation : aggregations.aggregations) {
                List aggs = aggByName.computeIfAbsent(aggregation.getName(), k -> new ArrayList(aggregationsList.size()));
                aggs.add((InternalAggregation)aggregation);
            }
        }
        ArrayList<InternalAggregation> reducedAggregations = new ArrayList<InternalAggregation>();
        for (Map.Entry entry : aggByName.entrySet()) {
            List aggregations = (List)entry.getValue();
            aggregations.sort(INTERNAL_AGG_COMPARATOR);
            InternalAggregation first = (InternalAggregation)aggregations.get(0);
            reducedAggregations.add(first.reduce(aggregations, context));
        }
        if (context.isFinalReduce()) {
            for (SiblingPipelineAggregator pipelineAggregator : topLevelPipelineAggregators) {
                InternalAggregation newAgg = pipelineAggregator.doReduce(new InternalAggregations((List<InternalAggregation>)reducedAggregations), context);
                reducedAggregations.add(newAgg);
            }
            return new InternalAggregations((List<InternalAggregation>)reducedAggregations);
        }
        return new InternalAggregations(reducedAggregations, topLevelPipelineAggregators);
    }

    public static InternalAggregations readAggregations(StreamInput in) throws IOException {
        InternalAggregations result = new InternalAggregations();
        result.readFrom(in);
        return result;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.aggregations = in.readList(stream -> in.readNamedWriteable(InternalAggregation.class));
        if (this.aggregations.isEmpty()) {
            this.aggregationsAsMap = Collections.emptyMap();
        }
        this.topLevelPipelineAggregators = in.getVersion().onOrAfter(Version.V_6_7_0) ? in.readList(stream -> (SiblingPipelineAggregator)in.readNamedWriteable(PipelineAggregator.class)) : Collections.emptyList();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeNamedWriteableList(this.aggregations);
        if (out.getVersion().onOrAfter(Version.V_6_7_0)) {
            out.writeNamedWriteableList(this.topLevelPipelineAggregators);
        }
    }
}

