/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.script.mustache;

import java.io.IOException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.node.NodeClient;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.BaseRestHandler;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.RestChannel;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.RestController;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.RestRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.action.RestToXContentListener;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.script.ScriptType;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.script.mustache.SearchTemplateAction;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.script.mustache.SearchTemplateRequest;

public class RestRenderSearchTemplateAction
extends BaseRestHandler {
    public RestRenderSearchTemplateAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.GET, "/_render/template", this);
        controller.registerHandler(RestRequest.Method.POST, "/_render/template", this);
        controller.registerHandler(RestRequest.Method.GET, "/_render/template/{id}", this);
        controller.registerHandler(RestRequest.Method.POST, "/_render/template/{id}", this);
    }

    @Override
    public String getName() {
        return "render_search_template_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        SearchTemplateRequest renderRequest;
        try (XContentParser parser = request.contentOrSourceParamParser();){
            renderRequest = SearchTemplateRequest.fromXContent(parser);
        }
        renderRequest.setSimulate(true);
        String id = request.param("id");
        if (id != null) {
            renderRequest.setScriptType(ScriptType.STORED);
            renderRequest.setScript(id);
        }
        return channel -> client.execute(SearchTemplateAction.INSTANCE, renderRequest, new RestToXContentListener((RestChannel)channel));
    }
}

