/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.script.mustache;

import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.AccessController;
import java.util.Map;
import org.apache.flink.elasticsearch6.shaded.com.github.mustachejava.Mustache;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.SpecialPermission;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.script.GeneralScriptException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.script.ScriptContext;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.script.ScriptEngine;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.script.TemplateScript;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.script.mustache.CustomMustacheFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;

public final class MustacheScriptEngine
implements ScriptEngine {
    private static final Logger logger = LogManager.getLogger(MustacheScriptEngine.class);
    public static final String NAME = "mustache";

    public <T> T compile(String templateName, String templateSource, ScriptContext<T> context, Map<String, String> options) {
        if (!context.instanceClazz.equals(TemplateScript.class)) {
            throw new IllegalArgumentException("mustache engine does not know how to handle context [" + context.name + "]");
        }
        CustomMustacheFactory factory = this.createMustacheFactory(options);
        StringReader reader = new StringReader(templateSource);
        Mustache template = factory.compile(reader, "query-template");
        TemplateScript.Factory compiled = params -> new MustacheExecutableScript(template, params);
        return (T)context.factoryClazz.cast(compiled);
    }

    private CustomMustacheFactory createMustacheFactory(Map<String, String> options) {
        if (options == null || options.isEmpty() || !options.containsKey("content_type")) {
            return new CustomMustacheFactory();
        }
        return new CustomMustacheFactory(options.get("content_type"));
    }

    @Override
    public String getType() {
        return NAME;
    }

    private class MustacheExecutableScript
    extends TemplateScript {
        private Mustache template;
        private Map<String, Object> params;

        MustacheExecutableScript(Mustache template, Map<String, Object> params) {
            super(params);
            this.template = template;
            this.params = params;
        }

        @Override
        public String execute() {
            StringWriter writer = new StringWriter();
            try {
                SpecialPermission.check();
                AccessController.doPrivileged(() -> {
                    this.template.execute((Writer)writer, this.params);
                    return null;
                });
            }
            catch (Exception e) {
                logger.error(() -> new ParameterizedMessage("Error running {}", (Object)this.template), (Throwable)e);
                throw new GeneralScriptException("Error running " + this.template, e);
            }
            return writer.toString();
        }
    }
}

