/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.action.admin.indices;

import java.io.IOException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.indices.shrink.ResizeRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.indices.shrink.ResizeResponse;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.indices.shrink.ResizeType;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.support.ActiveShardCount;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.node.NodeClient;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.Booleans;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.logging.DeprecationLogger;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.BaseRestHandler;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.RestChannel;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.RestController;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.RestRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.action.RestToXContentListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class RestResizeHandler
extends BaseRestHandler {
    private static final Logger logger = LogManager.getLogger(RestResizeHandler.class);
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(logger);

    RestResizeHandler(Settings settings) {
        super(settings);
    }

    @Override
    public abstract String getName();

    abstract ResizeType getResizeType();

    @Override
    public final BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        Boolean copySettings;
        ResizeRequest resizeRequest = new ResizeRequest(request.param("target"), request.param("index"));
        resizeRequest.setResizeType(this.getResizeType());
        String rawCopySettings = request.param("copy_settings");
        if (rawCopySettings == null) {
            copySettings = resizeRequest.getCopySettings();
        } else if (rawCopySettings.isEmpty()) {
            copySettings = true;
        } else {
            copySettings = Booleans.parseBoolean(rawCopySettings);
            if (!copySettings.booleanValue()) {
                throw new IllegalArgumentException("parameter [copy_settings] can not be explicitly set to [false]");
            }
        }
        if (copySettings == null) {
            deprecationLogger.deprecated("resize operations without copying settings is deprecated; set parameter [copy_settings] to [true] for future default behavior", new Object[0]);
        }
        resizeRequest.setCopySettings(copySettings);
        request.applyContentParser(resizeRequest::fromXContent);
        resizeRequest.timeout(request.paramAsTime("timeout", resizeRequest.timeout()));
        resizeRequest.masterNodeTimeout(request.paramAsTime("master_timeout", resizeRequest.masterNodeTimeout()));
        resizeRequest.setWaitForActiveShards(ActiveShardCount.parseString(request.param("wait_for_active_shards")));
        return channel -> client.admin().indices().resizeIndex(resizeRequest, new RestToXContentListener<ResizeResponse>((RestChannel)channel));
    }

    public static class RestSplitIndexAction
    extends RestResizeHandler {
        public RestSplitIndexAction(Settings settings, RestController controller) {
            super(settings);
            controller.registerHandler(RestRequest.Method.PUT, "/{index}/_split/{target}", this);
            controller.registerHandler(RestRequest.Method.POST, "/{index}/_split/{target}", this);
        }

        @Override
        public String getName() {
            return "split_index_action";
        }

        @Override
        protected ResizeType getResizeType() {
            return ResizeType.SPLIT;
        }
    }

    public static class RestShrinkIndexAction
    extends RestResizeHandler {
        public RestShrinkIndexAction(Settings settings, RestController controller) {
            super(settings);
            controller.registerHandler(RestRequest.Method.PUT, "/{index}/_shrink/{target}", this);
            controller.registerHandler(RestRequest.Method.POST, "/{index}/_shrink/{target}", this);
        }

        @Override
        public String getName() {
            return "shrink_index_action";
        }

        @Override
        protected ResizeType getResizeType() {
            return ResizeType.SHRINK;
        }
    }
}

