/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.action.admin.indices;

import java.io.IOException;
import java.util.Map;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.support.IndicesOptions;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.Requests;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.node.NodeClient;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.logging.DeprecationLogger;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentHelper;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.mapper.MapperService;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.BaseRestHandler;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.RestChannel;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.RestController;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.RestRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.action.RestToXContentListener;
import org.apache.logging.log4j.LogManager;

public class RestPutMappingAction
extends BaseRestHandler {
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(LogManager.getLogger(RestPutMappingAction.class));
    static final String TYPES_DEPRECATION_MESSAGE = "[types removal] The parameter include_type_name should be explicitly specified in put mapping requests to prepare for 7.0. In 7.0 include_type_name will default to 'false', and requests are expected to omit the type name in mapping definitions.";

    public RestPutMappingAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.PUT, "/{index}/_mapping/", this);
        controller.registerHandler(RestRequest.Method.PUT, "/{index}/{type}/_mapping", this);
        controller.registerHandler(RestRequest.Method.PUT, "/{index}/_mapping/{type}", this);
        controller.registerHandler(RestRequest.Method.PUT, "/_mapping/{type}", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_mapping/", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/_mapping", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_mapping/{type}", this);
        controller.registerHandler(RestRequest.Method.POST, "/_mapping/{type}", this);
        controller.registerHandler(RestRequest.Method.PUT, "/{index}/_mappings/", this);
        controller.registerHandler(RestRequest.Method.PUT, "/{index}/{type}/_mappings", this);
        controller.registerHandler(RestRequest.Method.PUT, "/{index}/_mappings/{type}", this);
        controller.registerHandler(RestRequest.Method.PUT, "/_mappings/{type}", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_mappings/", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/_mappings", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_mappings/{type}", this);
        controller.registerHandler(RestRequest.Method.POST, "/_mappings/{type}", this);
    }

    @Override
    public String getName() {
        return "put_mapping_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        boolean includeTypeName;
        PutMappingRequest putMappingRequest = Requests.putMappingRequest(Strings.splitStringByCommaToArray(request.param("index")));
        String type = request.param("type");
        Map<String, Object> sourceAsMap = XContentHelper.convertToMap(request.requiredContent(), false, request.getXContentType()).v2();
        if (!request.hasParam("include_type_name")) {
            deprecationLogger.deprecatedAndMaybeLog("put_mapping_with_types", TYPES_DEPRECATION_MESSAGE, new Object[0]);
        }
        if (!(includeTypeName = request.paramAsBoolean("include_type_name", true)) && (type != null || MapperService.isMappingSourceTyped("_doc", sourceAsMap))) {
            throw new IllegalArgumentException("Types cannot be provided in put mapping requests, unless the include_type_name parameter is set to true.");
        }
        putMappingRequest.type(includeTypeName ? type : "_doc");
        putMappingRequest.source(sourceAsMap);
        if (request.hasParam("update_all_types")) {
            deprecationLogger.deprecated("[update_all_types] is deprecated since indices may not have more than one type anymore", new Object[0]);
        }
        putMappingRequest.updateAllTypes(request.paramAsBoolean("update_all_types", false));
        putMappingRequest.timeout(request.paramAsTime("timeout", putMappingRequest.timeout()));
        putMappingRequest.masterNodeTimeout(request.paramAsTime("master_timeout", putMappingRequest.masterNodeTimeout()));
        putMappingRequest.indicesOptions(IndicesOptions.fromRequest(request, putMappingRequest.indicesOptions()));
        return channel -> client.admin().indices().putMapping(putMappingRequest, new RestToXContentListener<AcknowledgedResponse>((RestChannel)channel));
    }
}

