/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.query.functionscore;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.NamedWriteable;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.logging.DeprecationLogger;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.lucene.search.function.ScoreFunction;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.lucene.search.function.WeightFactorFunction;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ToXContentFragment;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.query.QueryShardContext;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.query.functionscore.FunctionScoreQueryBuilder;
import org.apache.logging.log4j.LogManager;

public abstract class ScoreFunctionBuilder<FB extends ScoreFunctionBuilder<FB>>
implements ToXContentFragment,
NamedWriteable {
    private static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(LogManager.getLogger(ScoreFunctionBuilder.class));
    private Float weight;

    public ScoreFunctionBuilder() {
    }

    public ScoreFunctionBuilder(StreamInput in) throws IOException {
        this.weight = this.checkWeight(in.readOptionalFloat());
    }

    @Override
    public final void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalFloat(this.weight);
        this.doWriteTo(out);
    }

    protected abstract void doWriteTo(StreamOutput var1) throws IOException;

    public abstract String getName();

    public final FB setWeight(float weight) {
        this.weight = this.checkWeight(Float.valueOf(weight));
        return (FB)this;
    }

    private Float checkWeight(Float weight) {
        if (weight != null && Float.compare(weight.floatValue(), 0.0f) < 0) {
            DEPRECATION_LOGGER.deprecated("Setting a negative [weight] in Function Score Query is deprecated and will throw an error in the next major version", new Object[0]);
        }
        return weight;
    }

    public final Float getWeight() {
        return this.weight;
    }

    @Override
    public final XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.weight != null) {
            builder.field(FunctionScoreQueryBuilder.WEIGHT_FIELD.getPreferredName(), this.weight);
        }
        this.doXContent(builder, params);
        return builder;
    }

    protected abstract void doXContent(XContentBuilder var1, ToXContent.Params var2) throws IOException;

    @Override
    public final String getWriteableName() {
        return this.getName();
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ScoreFunctionBuilder other = (ScoreFunctionBuilder)obj;
        return Objects.equals(this.weight, other.getWeight()) && this.doEquals(other);
    }

    protected abstract boolean doEquals(FB var1);

    public final int hashCode() {
        return Objects.hash(this.getClass(), this.weight, this.doHashCode());
    }

    protected abstract int doHashCode();

    public final ScoreFunction toFunction(QueryShardContext context) throws IOException {
        ScoreFunction scoreFunction = this.doToFunction(context);
        if (this.weight == null) {
            return scoreFunction;
        }
        return new WeightFactorFunction(this.weight.floatValue(), scoreFunction);
    }

    protected abstract ScoreFunction doToFunction(QueryShardContext var1) throws IOException;
}

