/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.analysis;

import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.Analyzer;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.TokenStream;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.synonym.SynonymGraphFilter;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.synonym.SynonymMap;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.env.Environment;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.IndexSettings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.analysis.AnalysisRegistry;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.analysis.CharFilterFactory;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.analysis.SynonymTokenFilterFactory;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.analysis.TokenFilterFactory;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.analysis.TokenizerFactory;

public class SynonymGraphTokenFilterFactory
extends SynonymTokenFilterFactory {
    public SynonymGraphTokenFilterFactory(IndexSettings indexSettings, Environment env, AnalysisRegistry analysisRegistry, String name, Settings settings) throws IOException {
        super(indexSettings, env, analysisRegistry, name, settings);
    }

    @Override
    public TokenStream create(TokenStream tokenStream) {
        throw new IllegalStateException("Call createPerAnalyzerSynonymGraphFactory to specialize this factory for an analysis chain first");
    }

    @Override
    public TokenFilterFactory getChainAwareTokenFilterFactory(TokenizerFactory tokenizer, List<CharFilterFactory> charFilters, List<TokenFilterFactory> previousTokenFilters, Function<String, TokenFilterFactory> allFilters) {
        Analyzer analyzer = this.buildSynonymAnalyzer(tokenizer, charFilters, previousTokenFilters);
        final SynonymMap synonyms = this.buildSynonyms(analyzer, this.getRulesFromSettings(this.environment));
        final String name = this.name();
        return new TokenFilterFactory(){

            @Override
            public String name() {
                return name;
            }

            @Override
            public TokenStream create(TokenStream tokenStream) {
                return synonyms.fst == null ? tokenStream : new SynonymGraphFilter(tokenStream, synonyms, SynonymGraphTokenFilterFactory.this.ignoreCase);
            }
        };
    }
}

