/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.gateway;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.flink.elasticsearch6.shaded.com.carrotsearch.hppc.cursors.ObjectCursor;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.ClusterChangedEvent;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.ClusterState;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.ClusterStateListener;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.block.ClusterBlock;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.block.ClusterBlocks;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.metadata.IndexMetaData;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.metadata.MetaData;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.node.DiscoveryNodes;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.routing.RoutingTable;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.service.ClusterService;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.inject.Inject;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Setting;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.unit.TimeValue;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.gateway.Gateway;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.gateway.GatewayMetaState;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.gateway.TransportNodesListGatewayMetaState;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.indices.IndicesService;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.RestStatus;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.threadpool.ThreadPool;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;

public class GatewayService
extends AbstractLifecycleComponent
implements ClusterStateListener {
    private static final Logger logger = LogManager.getLogger(GatewayService.class);
    public static final Setting<Integer> EXPECTED_NODES_SETTING = Setting.intSetting("gateway.expected_nodes", -1, -1, Setting.Property.NodeScope);
    public static final Setting<Integer> EXPECTED_DATA_NODES_SETTING = Setting.intSetting("gateway.expected_data_nodes", -1, -1, Setting.Property.NodeScope);
    public static final Setting<Integer> EXPECTED_MASTER_NODES_SETTING = Setting.intSetting("gateway.expected_master_nodes", -1, -1, Setting.Property.NodeScope);
    public static final Setting<TimeValue> RECOVER_AFTER_TIME_SETTING = Setting.positiveTimeSetting("gateway.recover_after_time", TimeValue.timeValueMillis(0L), Setting.Property.NodeScope);
    public static final Setting<Integer> RECOVER_AFTER_NODES_SETTING = Setting.intSetting("gateway.recover_after_nodes", -1, -1, Setting.Property.NodeScope);
    public static final Setting<Integer> RECOVER_AFTER_DATA_NODES_SETTING = Setting.intSetting("gateway.recover_after_data_nodes", -1, -1, Setting.Property.NodeScope);
    public static final Setting<Integer> RECOVER_AFTER_MASTER_NODES_SETTING = Setting.intSetting("gateway.recover_after_master_nodes", 0, 0, Setting.Property.NodeScope);
    public static final ClusterBlock STATE_NOT_RECOVERED_BLOCK = new ClusterBlock(1, "state not recovered / initialized", true, true, false, RestStatus.SERVICE_UNAVAILABLE, ClusterBlockLevel.ALL);
    public static final TimeValue DEFAULT_RECOVER_AFTER_TIME_IF_EXPECTED_NODES_IS_SET = TimeValue.timeValueMinutes(5L);
    private final Gateway gateway;
    private final ThreadPool threadPool;
    private final AllocationService allocationService;
    private final ClusterService clusterService;
    private final TimeValue recoverAfterTime;
    private final int recoverAfterNodes;
    private final int expectedNodes;
    private final int recoverAfterDataNodes;
    private final int expectedDataNodes;
    private final int recoverAfterMasterNodes;
    private final int expectedMasterNodes;
    private final AtomicBoolean recovered = new AtomicBoolean();
    private final AtomicBoolean scheduledRecovery = new AtomicBoolean();

    @Inject
    public GatewayService(Settings settings, AllocationService allocationService, ClusterService clusterService, ThreadPool threadPool, GatewayMetaState metaState, TransportNodesListGatewayMetaState listGatewayMetaState, IndicesService indicesService) {
        this.gateway = new Gateway(settings, clusterService, listGatewayMetaState, indicesService);
        this.allocationService = allocationService;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.expectedNodes = EXPECTED_NODES_SETTING.get(settings);
        this.expectedDataNodes = EXPECTED_DATA_NODES_SETTING.get(settings);
        this.expectedMasterNodes = EXPECTED_MASTER_NODES_SETTING.get(settings);
        this.recoverAfterTime = RECOVER_AFTER_TIME_SETTING.exists(settings) ? RECOVER_AFTER_TIME_SETTING.get(settings) : (this.expectedNodes >= 0 || this.expectedDataNodes >= 0 || this.expectedMasterNodes >= 0 ? DEFAULT_RECOVER_AFTER_TIME_IF_EXPECTED_NODES_IS_SET : null);
        this.recoverAfterNodes = RECOVER_AFTER_NODES_SETTING.get(settings);
        this.recoverAfterDataNodes = RECOVER_AFTER_DATA_NODES_SETTING.get(settings);
        this.recoverAfterMasterNodes = RECOVER_AFTER_MASTER_NODES_SETTING.exists(settings) ? RECOVER_AFTER_MASTER_NODES_SETTING.get(settings).intValue() : settings.getAsInt("discovery.zen.minimum_master_nodes", -1).intValue();
        clusterService.addLowPriorityApplier(metaState);
    }

    @Override
    protected void doStart() {
        this.clusterService.addListener(this);
    }

    @Override
    protected void doStop() {
        this.clusterService.removeListener(this);
    }

    @Override
    protected void doClose() {
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        if (this.lifecycle.stoppedOrClosed()) {
            return;
        }
        ClusterState state = event.state();
        if (!state.nodes().isLocalNodeElectedMaster()) {
            return;
        }
        if (!state.blocks().hasGlobalBlock(STATE_NOT_RECOVERED_BLOCK)) {
            return;
        }
        DiscoveryNodes nodes = state.nodes();
        if (state.nodes().getMasterNodeId() == null) {
            logger.debug("not recovering from gateway, no master elected yet");
        } else if (this.recoverAfterNodes != -1 && nodes.getMasterAndDataNodes().size() < this.recoverAfterNodes) {
            logger.debug("not recovering from gateway, nodes_size (data+master) [{}] < recover_after_nodes [{}]", (Object)nodes.getMasterAndDataNodes().size(), (Object)this.recoverAfterNodes);
        } else if (this.recoverAfterDataNodes != -1 && nodes.getDataNodes().size() < this.recoverAfterDataNodes) {
            logger.debug("not recovering from gateway, nodes_size (data) [{}] < recover_after_data_nodes [{}]", (Object)nodes.getDataNodes().size(), (Object)this.recoverAfterDataNodes);
        } else if (this.recoverAfterMasterNodes != -1 && nodes.getMasterNodes().size() < this.recoverAfterMasterNodes) {
            logger.debug("not recovering from gateway, nodes_size (master) [{}] < recover_after_master_nodes [{}]", (Object)nodes.getMasterNodes().size(), (Object)this.recoverAfterMasterNodes);
        } else {
            String reason;
            boolean enforceRecoverAfterTime;
            if (this.expectedNodes == -1 && this.expectedMasterNodes == -1 && this.expectedDataNodes == -1) {
                enforceRecoverAfterTime = true;
                reason = "recover_after_time was set to [" + this.recoverAfterTime + "]";
            } else {
                enforceRecoverAfterTime = false;
                reason = "";
                if (this.expectedNodes != -1 && nodes.getMasterAndDataNodes().size() < this.expectedNodes) {
                    enforceRecoverAfterTime = true;
                    reason = "expecting [" + this.expectedNodes + "] nodes, but only have [" + nodes.getMasterAndDataNodes().size() + "]";
                } else if (this.expectedDataNodes != -1 && nodes.getDataNodes().size() < this.expectedDataNodes) {
                    enforceRecoverAfterTime = true;
                    reason = "expecting [" + this.expectedDataNodes + "] data nodes, but only have [" + nodes.getDataNodes().size() + "]";
                } else if (this.expectedMasterNodes != -1 && nodes.getMasterNodes().size() < this.expectedMasterNodes) {
                    enforceRecoverAfterTime = true;
                    reason = "expecting [" + this.expectedMasterNodes + "] master nodes, but only have [" + nodes.getMasterNodes().size() + "]";
                }
            }
            this.performStateRecovery(enforceRecoverAfterTime, reason);
        }
    }

    private void performStateRecovery(boolean enforceRecoverAfterTime, String reason) {
        final GatewayRecoveryListener recoveryListener = new GatewayRecoveryListener();
        if (enforceRecoverAfterTime && this.recoverAfterTime != null) {
            if (this.scheduledRecovery.compareAndSet(false, true)) {
                logger.info("delaying initial state recovery for [{}]. {}", (Object)this.recoverAfterTime, (Object)reason);
                this.threadPool.schedule(() -> {
                    if (this.recovered.compareAndSet(false, true)) {
                        logger.info("recover_after_time [{}] elapsed. performing state recovery...", (Object)this.recoverAfterTime);
                        this.gateway.performStateRecovery(recoveryListener);
                    }
                }, this.recoverAfterTime, "generic");
            }
        } else if (this.recovered.compareAndSet(false, true)) {
            this.threadPool.generic().execute(new AbstractRunnable(){

                @Override
                public void onFailure(Exception e) {
                    logger.warn("Recovery failed", (Throwable)e);
                    recoveryListener.onFailure("state recovery failed: " + e.getMessage());
                }

                @Override
                protected void doRun() throws Exception {
                    GatewayService.this.gateway.performStateRecovery(recoveryListener);
                }
            });
        }
    }

    public TimeValue recoverAfterTime() {
        return this.recoverAfterTime;
    }

    class GatewayRecoveryListener
    implements Gateway.GatewayStateRecoveredListener {
        GatewayRecoveryListener() {
        }

        @Override
        public void onSuccess(final ClusterState recoveredState) {
            logger.trace("successful state recovery, importing cluster state...");
            GatewayService.this.clusterService.submitStateUpdateTask("local-gateway-elected-state", new ClusterStateUpdateTask(){

                @Override
                public ClusterState execute(ClusterState currentState) {
                    assert (currentState.metaData().indices().isEmpty());
                    ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(currentState.blocks()).blocks(recoveredState.blocks()).removeGlobalBlock(STATE_NOT_RECOVERED_BLOCK);
                    MetaData.Builder metaDataBuilder = MetaData.builder(recoveredState.metaData());
                    metaDataBuilder.generateClusterUuidIfNeeded();
                    if (MetaData.SETTING_READ_ONLY_SETTING.get(recoveredState.metaData().settings()).booleanValue() || MetaData.SETTING_READ_ONLY_SETTING.get(currentState.metaData().settings()).booleanValue()) {
                        blocks.addGlobalBlock(MetaData.CLUSTER_READ_ONLY_BLOCK);
                    }
                    if (MetaData.SETTING_READ_ONLY_ALLOW_DELETE_SETTING.get(recoveredState.metaData().settings()).booleanValue() || MetaData.SETTING_READ_ONLY_ALLOW_DELETE_SETTING.get(currentState.metaData().settings()).booleanValue()) {
                        blocks.addGlobalBlock(MetaData.CLUSTER_READ_ONLY_ALLOW_DELETE_BLOCK);
                    }
                    for (IndexMetaData indexMetaData : recoveredState.metaData()) {
                        metaDataBuilder.put(indexMetaData, false);
                        blocks.addBlocks(indexMetaData);
                    }
                    ClusterState updatedState = ClusterState.builder(currentState).blocks(blocks).metaData(metaDataBuilder).build();
                    RoutingTable.Builder routingTableBuilder = RoutingTable.builder(updatedState.routingTable());
                    for (ObjectCursor<IndexMetaData> objectCursor : updatedState.metaData().indices().values()) {
                        routingTableBuilder.addAsRecovery((IndexMetaData)objectCursor.value);
                    }
                    routingTableBuilder.version(0L);
                    updatedState = ClusterState.builder(updatedState).routingTable(routingTableBuilder.build()).build();
                    return GatewayService.this.allocationService.reroute(updatedState, "state recovered");
                }

                @Override
                public void onFailure(String source, Exception e) {
                    logger.error(() -> new ParameterizedMessage("unexpected failure during [{}]", (Object)source), (Throwable)e);
                    GatewayRecoveryListener.this.onFailure("failed to updated cluster state");
                }

                @Override
                public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                    logger.info("recovered [{}] indices into cluster_state", (Object)newState.metaData().indices().size());
                }
            });
        }

        @Override
        public void onFailure(String message) {
            GatewayService.this.recovered.set(false);
            GatewayService.this.scheduledRecovery.set(false);
            logger.info("metadata state not restored, reason: {}", (Object)message);
        }
    }
}

