/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.search;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ActionListener;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.search.AbstractSearchAsyncAction;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.search.DfsQueryPhase;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.search.FetchSearchPhase;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.search.InitialSearchPhase;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.search.SearchActionListener;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.search.SearchPhase;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.search.SearchPhaseContext;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.search.SearchPhaseController;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.search.SearchRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.search.SearchResponse;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.search.SearchShardIterator;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.search.SearchTask;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.search.SearchTransportService;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.search.TransportSearchAction;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.routing.ShardRouting;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.SearchPhaseResult;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.dfs.DfsSearchResult;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.internal.AliasFilter;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.transport.Transport;
import org.apache.logging.log4j.Logger;

final class SearchDfsQueryThenFetchAsyncAction
extends AbstractSearchAsyncAction<DfsSearchResult> {
    private final SearchPhaseController searchPhaseController;

    SearchDfsQueryThenFetchAsyncAction(Logger logger, SearchTransportService searchTransportService, BiFunction<String, String, Transport.Connection> nodeIdToConnection, Map<String, AliasFilter> aliasFilter, Map<String, Float> concreteIndexBoosts, Map<String, Set<String>> indexRoutings, SearchPhaseController searchPhaseController, Executor executor, SearchRequest request, ActionListener<SearchResponse> listener, GroupShardsIterator<SearchShardIterator> shardsIts, TransportSearchAction.SearchTimeProvider timeProvider, long clusterStateVersion, SearchTask task, SearchResponse.Clusters clusters) {
        super("dfs", logger, searchTransportService, nodeIdToConnection, aliasFilter, concreteIndexBoosts, indexRoutings, executor, request, listener, shardsIts, timeProvider, clusterStateVersion, task, new InitialSearchPhase.ArraySearchPhaseResults(shardsIts.size()), request.getMaxConcurrentShardRequests(), clusters);
        this.searchPhaseController = searchPhaseController;
    }

    @Override
    protected void executePhaseOnShard(SearchShardIterator shardIt, ShardRouting shard, SearchActionListener<DfsSearchResult> listener) {
        this.getSearchTransport().sendExecuteDfs(this.getConnection(shardIt.getClusterAlias(), shard.currentNodeId()), this.buildShardSearchRequest(shardIt), this.getTask(), listener);
    }

    @Override
    protected SearchPhase getNextPhase(InitialSearchPhase.SearchPhaseResults<DfsSearchResult> results, SearchPhaseContext context) {
        return new DfsQueryPhase(results.getAtomicArray(), this.searchPhaseController, queryResults -> new FetchSearchPhase((InitialSearchPhase.SearchPhaseResults<SearchPhaseResult>)queryResults, this.searchPhaseController, context), context);
    }
}

