/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ingest;

import java.util.ArrayList;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ActionListener;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ActionRunnable;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ingest.SimulateDocumentBaseResult;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ingest.SimulateDocumentResult;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ingest.SimulateDocumentVerboseResult;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ingest.SimulatePipelineRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ingest.SimulatePipelineResponse;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ingest.SimulateProcessorResult;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.ingest.CompoundProcessor;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.ingest.IngestDocument;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.ingest.Pipeline;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.ingest.TrackingResultProcessor;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.threadpool.ThreadPool;

class SimulateExecutionService {
    private static final String THREAD_POOL_NAME = "management";
    private final ThreadPool threadPool;

    SimulateExecutionService(ThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    SimulateDocumentResult executeDocument(Pipeline pipeline, IngestDocument ingestDocument, boolean verbose) {
        if (verbose) {
            ArrayList<SimulateProcessorResult> processorResultList = new ArrayList<SimulateProcessorResult>();
            CompoundProcessor verbosePipelineProcessor = TrackingResultProcessor.decorate(pipeline.getCompoundProcessor(), processorResultList);
            try {
                Pipeline verbosePipeline = new Pipeline(pipeline.getId(), pipeline.getDescription(), pipeline.getVersion(), verbosePipelineProcessor);
                ingestDocument.executePipeline(verbosePipeline);
                return new SimulateDocumentVerboseResult(processorResultList);
            }
            catch (Exception e) {
                return new SimulateDocumentVerboseResult(processorResultList);
            }
        }
        try {
            pipeline.execute(ingestDocument);
            return new SimulateDocumentBaseResult(ingestDocument);
        }
        catch (Exception e) {
            return new SimulateDocumentBaseResult(e);
        }
    }

    public void execute(final SimulatePipelineRequest.Parsed request, ActionListener<SimulatePipelineResponse> listener) {
        this.threadPool.executor(THREAD_POOL_NAME).execute(new ActionRunnable<SimulatePipelineResponse>(listener){

            @Override
            protected void doRun() throws Exception {
                ArrayList<SimulateDocumentResult> responses = new ArrayList<SimulateDocumentResult>();
                for (IngestDocument ingestDocument : request.getDocuments()) {
                    SimulateDocumentResult response = SimulateExecutionService.this.executeDocument(request.getPipeline(), ingestDocument, request.isVerbose());
                    if (response == null) continue;
                    responses.add(response);
                }
                this.listener.onResponse(new SimulatePipelineResponse(request.getPipeline().getId(), request.isVerbose(), responses));
            }
        });
    }
}

