/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.delete;

import java.io.IOException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ActionRequestValidationException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.CompositeIndicesRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.DocWriteRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ValidateActions;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.support.replication.ReplicatedWriteRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.VersionType;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.shard.ShardId;

public class DeleteRequest
extends ReplicatedWriteRequest<DeleteRequest>
implements DocWriteRequest<DeleteRequest>,
CompositeIndicesRequest {
    private String type;
    private String id;
    @Nullable
    private String routing;
    @Nullable
    private String parent;
    private long version = -3L;
    private VersionType versionType = VersionType.INTERNAL;
    private long ifSeqNo = -2L;
    private long ifPrimaryTerm = 0L;

    public DeleteRequest() {
    }

    public DeleteRequest(String index) {
        this.index = index;
    }

    public DeleteRequest(String index, String type, String id) {
        this.index = index;
        this.type = type;
        this.id = id;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validate();
        if (Strings.isEmpty(this.type)) {
            validationException = ValidateActions.addValidationError("type is missing", validationException);
        }
        if (Strings.isEmpty(this.id)) {
            validationException = ValidateActions.addValidationError("id is missing", validationException);
        }
        validationException = DocWriteRequest.validateSeqNoBasedCASParams(this, validationException);
        return validationException;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public DeleteRequest type(String type) {
        this.type = type;
        return this;
    }

    @Override
    public String id() {
        return this.id;
    }

    public DeleteRequest id(String id) {
        this.id = id;
        return this;
    }

    @Override
    public String parent() {
        return this.parent;
    }

    public DeleteRequest parent(String parent) {
        this.parent = parent;
        return this;
    }

    @Override
    public DeleteRequest routing(String routing) {
        this.routing = routing != null && routing.length() == 0 ? null : routing;
        return this;
    }

    @Override
    public String routing() {
        return this.routing;
    }

    @Override
    public DeleteRequest version(long version) {
        this.version = version;
        return this;
    }

    @Override
    public long version() {
        return this.version;
    }

    @Override
    public DeleteRequest versionType(VersionType versionType) {
        this.versionType = versionType;
        return this;
    }

    @Override
    public long ifSeqNo() {
        return this.ifSeqNo;
    }

    @Override
    public long ifPrimaryTerm() {
        return this.ifPrimaryTerm;
    }

    @Override
    public DeleteRequest setIfSeqNo(long seqNo) {
        if (seqNo < 0L && seqNo != -2L) {
            throw new IllegalArgumentException("sequence numbers must be non negative. got [" + seqNo + "].");
        }
        this.ifSeqNo = seqNo;
        return this;
    }

    @Override
    public DeleteRequest setIfPrimaryTerm(long term) {
        if (term < 0L) {
            throw new IllegalArgumentException("primary term must be non negative. got [" + term + "]");
        }
        this.ifPrimaryTerm = term;
        return this;
    }

    @Override
    public VersionType versionType() {
        return this.versionType;
    }

    @Override
    public DocWriteRequest.OpType opType() {
        return DocWriteRequest.OpType.DELETE;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.type = in.readString();
        this.id = in.readString();
        this.routing = in.readOptionalString();
        this.parent = in.readOptionalString();
        this.version = in.readLong();
        this.versionType = VersionType.fromValue(in.readByte());
        if (in.getVersion().onOrAfter(Version.V_6_6_0)) {
            this.ifSeqNo = in.readZLong();
            this.ifPrimaryTerm = in.readVLong();
        } else {
            this.ifSeqNo = -2L;
            this.ifPrimaryTerm = 0L;
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.type);
        out.writeString(this.id);
        out.writeOptionalString(this.routing());
        out.writeOptionalString(this.parent());
        out.writeLong(this.version);
        out.writeByte(this.versionType.getValue());
        if (out.getVersion().onOrAfter(Version.V_6_6_0)) {
            out.writeZLong(this.ifSeqNo);
            out.writeVLong(this.ifPrimaryTerm);
        } else if (this.ifSeqNo != -2L || this.ifPrimaryTerm != 0L) {
            assert (false) : "ifSeqNo [" + this.ifSeqNo + "], ifPrimaryTerm [" + this.ifPrimaryTerm + "]";
            throw new IllegalStateException("sequence number based compare and write is not supported until all nodes are on version 6.6.0 or higher. Stream version [" + out.getVersion() + "]");
        }
    }

    @Override
    public String toString() {
        return "delete {[" + this.index + "][" + this.type + "][" + this.id + "]}";
    }

    @Override
    public DeleteRequest setShardId(ShardId shardId) {
        throw new UnsupportedOperationException("shard id should never be set on DeleteRequest");
    }
}

