/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util;

public final class FutureArrays {
    private FutureArrays() {
    }

    private static void checkFromToIndex(int fromIndex, int toIndex, int length) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex " + fromIndex + " > toIndex " + toIndex);
        }
        if (fromIndex < 0 || toIndex > length) {
            throw new IndexOutOfBoundsException("Range [" + fromIndex + ", " + toIndex + ") out-of-bounds for length " + length);
        }
    }

    public static int mismatch(byte[] a, int aFromIndex, int aToIndex, byte[] b, int bFromIndex, int bToIndex) {
        FutureArrays.checkFromToIndex(aFromIndex, aToIndex, a.length);
        FutureArrays.checkFromToIndex(bFromIndex, bToIndex, b.length);
        int aLen = aToIndex - aFromIndex;
        int bLen = bToIndex - bFromIndex;
        int len = Math.min(aLen, bLen);
        for (int i = 0; i < len; ++i) {
            if (a[i + aFromIndex] == b[i + bFromIndex]) continue;
            return i;
        }
        return aLen == bLen ? -1 : len;
    }

    public static int compareUnsigned(byte[] a, int aFromIndex, int aToIndex, byte[] b, int bFromIndex, int bToIndex) {
        FutureArrays.checkFromToIndex(aFromIndex, aToIndex, a.length);
        FutureArrays.checkFromToIndex(bFromIndex, bToIndex, b.length);
        int aLen = aToIndex - aFromIndex;
        int bLen = bToIndex - bFromIndex;
        int len = Math.min(aLen, bLen);
        for (int i = 0; i < len; ++i) {
            int aByte = a[i + aFromIndex] & 0xFF;
            int bByte = b[i + bFromIndex] & 0xFF;
            int diff = aByte - bByte;
            if (diff == 0) continue;
            return diff;
        }
        return aLen - bLen;
    }

    public static boolean equals(byte[] a, int aFromIndex, int aToIndex, byte[] b, int bFromIndex, int bToIndex) {
        FutureArrays.checkFromToIndex(aFromIndex, aToIndex, a.length);
        FutureArrays.checkFromToIndex(bFromIndex, bToIndex, b.length);
        int aLen = aToIndex - aFromIndex;
        int bLen = bToIndex - bFromIndex;
        if (aLen != bLen) {
            return false;
        }
        for (int i = 0; i < aLen; ++i) {
            if (a[i + aFromIndex] == b[i + bFromIndex]) continue;
            return false;
        }
        return true;
    }

    public static int mismatch(char[] a, int aFromIndex, int aToIndex, char[] b, int bFromIndex, int bToIndex) {
        FutureArrays.checkFromToIndex(aFromIndex, aToIndex, a.length);
        FutureArrays.checkFromToIndex(bFromIndex, bToIndex, b.length);
        int aLen = aToIndex - aFromIndex;
        int bLen = bToIndex - bFromIndex;
        int len = Math.min(aLen, bLen);
        for (int i = 0; i < len; ++i) {
            if (a[i + aFromIndex] == b[i + bFromIndex]) continue;
            return i;
        }
        return aLen == bLen ? -1 : len;
    }

    public static int compare(char[] a, int aFromIndex, int aToIndex, char[] b, int bFromIndex, int bToIndex) {
        FutureArrays.checkFromToIndex(aFromIndex, aToIndex, a.length);
        FutureArrays.checkFromToIndex(bFromIndex, bToIndex, b.length);
        int aLen = aToIndex - aFromIndex;
        int bLen = bToIndex - bFromIndex;
        int len = Math.min(aLen, bLen);
        for (int i = 0; i < len; ++i) {
            char aInt = a[i + aFromIndex];
            char bInt = b[i + bFromIndex];
            if (aInt > bInt) {
                return 1;
            }
            if (aInt >= bInt) continue;
            return -1;
        }
        return aLen - bLen;
    }

    public static boolean equals(char[] a, int aFromIndex, int aToIndex, char[] b, int bFromIndex, int bToIndex) {
        FutureArrays.checkFromToIndex(aFromIndex, aToIndex, a.length);
        FutureArrays.checkFromToIndex(bFromIndex, bToIndex, b.length);
        int aLen = aToIndex - aFromIndex;
        int bLen = bToIndex - bFromIndex;
        if (aLen != bLen) {
            return false;
        }
        for (int i = 0; i < aLen; ++i) {
            if (a[i + aFromIndex] == b[i + bFromIndex]) continue;
            return false;
        }
        return true;
    }

    public static int compare(int[] a, int aFromIndex, int aToIndex, int[] b, int bFromIndex, int bToIndex) {
        FutureArrays.checkFromToIndex(aFromIndex, aToIndex, a.length);
        FutureArrays.checkFromToIndex(bFromIndex, bToIndex, b.length);
        int aLen = aToIndex - aFromIndex;
        int bLen = bToIndex - bFromIndex;
        int len = Math.min(aLen, bLen);
        for (int i = 0; i < len; ++i) {
            int aInt = a[i + aFromIndex];
            int bInt = b[i + bFromIndex];
            if (aInt > bInt) {
                return 1;
            }
            if (aInt >= bInt) continue;
            return -1;
        }
        return aLen - bLen;
    }

    public static boolean equals(int[] a, int aFromIndex, int aToIndex, int[] b, int bFromIndex, int bToIndex) {
        FutureArrays.checkFromToIndex(aFromIndex, aToIndex, a.length);
        FutureArrays.checkFromToIndex(bFromIndex, bToIndex, b.length);
        int aLen = aToIndex - aFromIndex;
        int bLen = bToIndex - bFromIndex;
        if (aLen != bLen) {
            return false;
        }
        for (int i = 0; i < aLen; ++i) {
            if (a[i + aFromIndex] == b[i + bFromIndex]) continue;
            return false;
        }
        return true;
    }

    public static int compare(long[] a, int aFromIndex, int aToIndex, long[] b, int bFromIndex, int bToIndex) {
        FutureArrays.checkFromToIndex(aFromIndex, aToIndex, a.length);
        FutureArrays.checkFromToIndex(bFromIndex, bToIndex, b.length);
        int aLen = aToIndex - aFromIndex;
        int bLen = bToIndex - bFromIndex;
        int len = Math.min(aLen, bLen);
        for (int i = 0; i < len; ++i) {
            long aInt = a[i + aFromIndex];
            long bInt = b[i + bFromIndex];
            if (aInt > bInt) {
                return 1;
            }
            if (aInt >= bInt) continue;
            return -1;
        }
        return aLen - bLen;
    }

    public static boolean equals(long[] a, int aFromIndex, int aToIndex, long[] b, int bFromIndex, int bToIndex) {
        FutureArrays.checkFromToIndex(aFromIndex, aToIndex, a.length);
        FutureArrays.checkFromToIndex(bFromIndex, bToIndex, b.length);
        int aLen = aToIndex - aFromIndex;
        int bLen = bToIndex - bFromIndex;
        if (aLen != bLen) {
            return false;
        }
        for (int i = 0; i < aLen; ++i) {
            if (a[i + aFromIndex] == b[i + bFromIndex]) continue;
            return false;
        }
        return true;
    }
}

