/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.suggest.document;

import java.io.IOException;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.TokenFilter;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.TokenStream;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.miscellaneous.ConcatenateGraphFilter;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.automaton.Automaton;

public final class CompletionTokenStream
extends TokenFilter {
    private final PayloadAttribute payloadAttr = this.addAttribute(PayloadAttribute.class);
    final TokenStream inputTokenStream;
    final boolean preserveSep;
    final boolean preservePositionIncrements;
    final int maxGraphExpansions;
    private BytesRef payload;

    CompletionTokenStream(TokenStream inputTokenStream) {
        this(inputTokenStream, true, true, 10000);
    }

    CompletionTokenStream(TokenStream inputTokenStream, boolean preserveSep, boolean preservePositionIncrements, int maxGraphExpansions) {
        super(new ConcatenateGraphFilter(inputTokenStream, preserveSep, preservePositionIncrements, maxGraphExpansions));
        this.inputTokenStream = inputTokenStream;
        this.preserveSep = preserveSep;
        this.preservePositionIncrements = preservePositionIncrements;
        this.maxGraphExpansions = maxGraphExpansions;
    }

    public void setPayload(BytesRef payload) {
        this.payload = payload;
    }

    @Override
    public boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            this.payloadAttr.setPayload(this.payload);
            return true;
        }
        return false;
    }

    public Automaton toAutomaton() throws IOException {
        return ((ConcatenateGraphFilter)this.input).toAutomaton();
    }

    public Automaton toAutomaton(boolean unicodeAware) throws IOException {
        return ((ConcatenateGraphFilter)this.input).toAutomaton(unicodeAware);
    }
}

