/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.com.carrotsearch.hppc;

import org.apache.flink.elasticsearch6.shaded.com.carrotsearch.hppc.BitMixer;
import org.apache.flink.elasticsearch6.shaded.com.carrotsearch.hppc.HashOrderMixing;
import org.apache.flink.elasticsearch6.shaded.com.carrotsearch.hppc.ObjectFloatHashMap;

public class ObjectFloatScatterMap<KType>
extends ObjectFloatHashMap<KType> {
    public ObjectFloatScatterMap() {
        this(4);
    }

    public ObjectFloatScatterMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public ObjectFloatScatterMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor, HashOrderMixing.none());
    }

    @Override
    protected int hashKey(KType key) {
        return BitMixer.mixPhi(key);
    }

    public static <KType> ObjectFloatScatterMap<KType> from(KType[] keys, float[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        ObjectFloatScatterMap<KType> map = new ObjectFloatScatterMap<KType>(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }
}

