/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.base.source.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.connector.source.SourceSplit;
import org.apache.flink.core.io.SimpleVersionedSerializer;

@Internal
public class SerdeUtils {
    private SerdeUtils() {
    }

    public static <SplitT extends SourceSplit, C extends Collection<SplitT>> byte[] serializeSplitAssignments(Map<Integer, C> splitAssignments, SimpleVersionedSerializer<SplitT> splitSerializer) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            Object object;
            try (DataOutputStream out = new DataOutputStream(baos);){
                out.writeInt(splitAssignments.size());
                out.writeInt(splitSerializer.getVersion());
                for (Map.Entry<Integer, C> entry : splitAssignments.entrySet()) {
                    int subtaskId = entry.getKey();
                    Collection splitsForSubtask = (Collection)entry.getValue();
                    out.writeInt(subtaskId);
                    out.writeInt(splitsForSubtask.size());
                    for (SourceSplit split : splitsForSubtask) {
                        byte[] serializedSplit = splitSerializer.serialize((Object)split);
                        out.writeInt(serializedSplit.length);
                        out.write(serializedSplit);
                    }
                }
                object = baos.toByteArray();
            }
            return object;
        }
    }

    public static <SplitT extends SourceSplit, C extends Collection<SplitT>> Map<Integer, C> deserializeSplitAssignments(byte[] serialized, SimpleVersionedSerializer<SplitT> splitSerializer, Function<Integer, C> collectionSupplier) throws IOException {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(serialized);){
            HashMap<Integer, Collection> hashMap;
            try (DataInputStream in = new DataInputStream(bais);){
                int numSubtasks = in.readInt();
                HashMap<Integer, Collection> splitsAssignments = new HashMap<Integer, Collection>(numSubtasks);
                int serializerVersion = in.readInt();
                for (int i = 0; i < numSubtasks; ++i) {
                    int subtaskId = in.readInt();
                    int numAssignedSplits = in.readInt();
                    Collection assignedSplits = (Collection)collectionSupplier.apply(numAssignedSplits);
                    for (int j = 0; j < numAssignedSplits; ++j) {
                        int serializedSplitSize = in.readInt();
                        byte[] serializedSplit = new byte[serializedSplitSize];
                        in.readFully(serializedSplit);
                        SourceSplit split = (SourceSplit)splitSerializer.deserialize(serializerVersion, serializedSplit);
                        assignedSplits.add(split);
                    }
                    splitsAssignments.put(subtaskId, assignedSplits);
                }
                hashMap = splitsAssignments;
            }
            return hashMap;
        }
    }
}

