/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.transport;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ActionListener;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.transport.TransportRequest;

public final class TransportRequestDeduplicator<T extends TransportRequest> {
    private final ConcurrentMap<T, CompositeListener> requests = ConcurrentCollections.newConcurrentMap();

    public void executeOnce(T request, ActionListener<Void> listener, BiConsumer<T, ActionListener<Void>> callback) {
        CompositeListener completionListener = this.requests.computeIfAbsent(request, x$0 -> new CompositeListener(this, x$0)).addListener(listener);
        if (completionListener != null) {
            callback.accept(request, completionListener);
        }
    }

    public int size() {
        return this.requests.size();
    }

    private static final class CompositeListener
    implements ActionListener<Void> {
        private final List<ActionListener<Void>> listeners = new ArrayList<ActionListener<Void>>();
        private final T request;
        private boolean isNotified;
        private Exception failure;
        final /* synthetic */ TransportRequestDeduplicator this$0;

        CompositeListener(T request) {
            this.this$0 = var1_1;
            this.request = request;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        CompositeListener addListener(ActionListener<Void> listener) {
            CompositeListener compositeListener = this;
            synchronized (compositeListener) {
                if (!this.isNotified) {
                    this.listeners.add(listener);
                    return this.listeners.size() == 1 ? this : null;
                }
            }
            if (this.failure != null) {
                listener.onFailure(this.failure);
            } else {
                listener.onResponse(null);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onCompleted(Exception failure) {
            CompositeListener compositeListener = this;
            synchronized (compositeListener) {
                this.failure = failure;
                this.isNotified = true;
            }
            try {
                if (failure == null) {
                    ActionListener.onResponse(this.listeners, null);
                } else {
                    ActionListener.onFailure(this.listeners, failure);
                }
            }
            finally {
                this.this$0.requests.remove(this.request);
            }
        }

        @Override
        public void onResponse(Void aVoid) {
            this.onCompleted(null);
        }

        @Override
        public void onFailure(Exception failure) {
            this.onCompleted(failure);
        }
    }
}

