/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.transport;

import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.util.concurrent.ThreadContext;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.transport.TransportStatus;

public abstract class NetworkMessage {
    protected final Version version;
    protected final ThreadContext threadContext;
    protected final ThreadContext.StoredContext storedContext;
    protected final long requestId;
    protected final byte status;

    NetworkMessage(ThreadContext threadContext, Version version, byte status, long requestId) {
        this.threadContext = threadContext;
        this.storedContext = threadContext.stashContext();
        this.storedContext.restore();
        this.version = version;
        this.requestId = requestId;
        this.status = status;
    }

    public Version getVersion() {
        return this.version;
    }

    public long getRequestId() {
        return this.requestId;
    }

    boolean isCompress() {
        return TransportStatus.isCompress(this.status);
    }

    ThreadContext.StoredContext getStoredContext() {
        return this.storedContext;
    }

    boolean isResponse() {
        return !TransportStatus.isRequest(this.status);
    }

    boolean isRequest() {
        return TransportStatus.isRequest(this.status);
    }

    boolean isHandshake() {
        return TransportStatus.isHandshake(this.status);
    }

    boolean isError() {
        return TransportStatus.isError(this.status);
    }
}

