/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.snapshots;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.SetOnce;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.ExceptionsHelper;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ActionListener;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ActionRequestValidationException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ActionResponse;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.support.ActionFilters;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.support.master.MasterNodeRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.ClusterChangedEvent;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.ClusterState;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.ClusterStateListener;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.ClusterStateTaskListener;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.SnapshotsInProgress;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.block.ClusterBlockException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.node.DiscoveryNode;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.service.ClusterService;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.Priority;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.collect.ImmutableOpenMap;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.inject.Inject;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.unit.TimeValue;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.engine.Engine;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.engine.SnapshotFailedEngineException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.shard.IndexEventListener;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.shard.IndexShard;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.shard.IndexShardState;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.shard.ShardId;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.snapshots.IndexShardSnapshotFailedException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.snapshots.IndexShardSnapshotStatus;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.indices.IndicesService;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.repositories.IndexId;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.repositories.Repository;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.snapshots.Snapshot;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.snapshots.SnapshotsService;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.threadpool.ThreadPool;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.transport.EmptyTransportResponseHandler;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.transport.TransportChannel;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.transport.TransportException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.transport.TransportRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.transport.TransportRequestDeduplicator;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.transport.TransportRequestHandler;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.transport.TransportResponse;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.transport.TransportResponseHandler;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.transport.TransportService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;

public class SnapshotShardsService
extends AbstractLifecycleComponent
implements ClusterStateListener,
IndexEventListener {
    private static final Logger logger = LogManager.getLogger(SnapshotShardsService.class);
    public static final String UPDATE_SNAPSHOT_STATUS_ACTION_NAME_V6 = "internal:cluster/snapshot/update_snapshot";
    public static final String UPDATE_SNAPSHOT_STATUS_ACTION_NAME = "internal:cluster/snapshot/update_snapshot_status";
    private final Settings settings;
    private final ClusterService clusterService;
    private final IndicesService indicesService;
    private final SnapshotsService snapshotsService;
    private final TransportService transportService;
    private final ThreadPool threadPool;
    private final Map<Snapshot, Map<ShardId, IndexShardSnapshotStatus>> shardSnapshots = new HashMap<Snapshot, Map<ShardId, IndexShardSnapshotStatus>>();
    private final TransportRequestDeduplicator<UpdateIndexShardSnapshotStatusRequest> remoteFailedRequestDeduplicator = new TransportRequestDeduplicator();
    private final SnapshotStateExecutor snapshotStateExecutor = new SnapshotStateExecutor();
    private final UpdateSnapshotStatusAction updateSnapshotStatusHandler;

    @Inject
    public SnapshotShardsService(Settings settings, ClusterService clusterService, SnapshotsService snapshotsService, ThreadPool threadPool, TransportService transportService, IndicesService indicesService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        this.settings = settings;
        this.indicesService = indicesService;
        this.snapshotsService = snapshotsService;
        this.transportService = transportService;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        if (DiscoveryNode.isDataNode(settings)) {
            clusterService.addListener(this);
        }
        this.updateSnapshotStatusHandler = new UpdateSnapshotStatusAction(transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver);
        if (DiscoveryNode.isMasterNode(settings)) {
            transportService.registerRequestHandler(UPDATE_SNAPSHOT_STATUS_ACTION_NAME_V6, UpdateSnapshotStatusRequestV6::new, "same", new UpdateSnapshotStateRequestHandlerV6());
        }
    }

    @Override
    protected void doStart() {
        assert (this.updateSnapshotStatusHandler != null);
        assert (this.transportService.getRequestHandler(UPDATE_SNAPSHOT_STATUS_ACTION_NAME) != null);
        if (DiscoveryNode.isMasterNode(this.settings)) assert (this.transportService.getRequestHandler(UPDATE_SNAPSHOT_STATUS_ACTION_NAME_V6) != null);
    }

    @Override
    protected void doStop() {
    }

    @Override
    protected void doClose() {
        this.clusterService.removeListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        try {
            SnapshotsInProgress previousSnapshots = (SnapshotsInProgress)event.previousState().custom("snapshots");
            SnapshotsInProgress currentSnapshots = (SnapshotsInProgress)event.state().custom("snapshots");
            if (previousSnapshots == null && currentSnapshots != null || previousSnapshots != null && !previousSnapshots.equals(currentSnapshots)) {
                Map<Snapshot, Map<ShardId, IndexShardSnapshotStatus>> map = this.shardSnapshots;
                synchronized (map) {
                    this.processIndexShardSnapshots(currentSnapshots, event.state().nodes().getMasterNode());
                }
            }
            String previousMasterNodeId = event.previousState().nodes().getMasterNodeId();
            String currentMasterNodeId = event.state().nodes().getMasterNodeId();
            if (currentMasterNodeId != null && !currentMasterNodeId.equals(previousMasterNodeId)) {
                this.syncShardStatsOnNewMaster(event);
            }
        }
        catch (Exception e) {
            logger.warn("Failed to update snapshot state ", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beforeIndexShardClosed(ShardId shardId, @Nullable IndexShard indexShard, Settings indexSettings) {
        Map<Snapshot, Map<ShardId, IndexShardSnapshotStatus>> map = this.shardSnapshots;
        synchronized (map) {
            for (Map.Entry<Snapshot, Map<ShardId, IndexShardSnapshotStatus>> snapshotShards : this.shardSnapshots.entrySet()) {
                Map<ShardId, IndexShardSnapshotStatus> shards = snapshotShards.getValue();
                if (!shards.containsKey(shardId)) continue;
                logger.debug("[{}] shard closing, abort snapshotting for snapshot [{}]", (Object)shardId, (Object)snapshotShards.getKey().getSnapshotId());
                shards.get(shardId).abortIfNotCompleted("shard is closing, aborting");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<ShardId, IndexShardSnapshotStatus> currentSnapshotShards(Snapshot snapshot) {
        Map<Snapshot, Map<ShardId, IndexShardSnapshotStatus>> map = this.shardSnapshots;
        synchronized (map) {
            Map<ShardId, IndexShardSnapshotStatus> current = this.shardSnapshots.get(snapshot);
            return current == null ? null : new HashMap<ShardId, IndexShardSnapshotStatus>(current);
        }
    }

    private void processIndexShardSnapshots(SnapshotsInProgress snapshotsInProgress, DiscoveryNode masterNode) {
        this.cancelRemoved(snapshotsInProgress);
        if (snapshotsInProgress != null) {
            this.startNewSnapshots(snapshotsInProgress, masterNode);
        }
    }

    private void cancelRemoved(@Nullable SnapshotsInProgress snapshotsInProgress) {
        Iterator<Map.Entry<Snapshot, Map<ShardId, IndexShardSnapshotStatus>>> it = this.shardSnapshots.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Snapshot, Map<ShardId, IndexShardSnapshotStatus>> entry = it.next();
            Snapshot snapshot = entry.getKey();
            if (snapshotsInProgress != null && snapshotsInProgress.snapshot(snapshot) != null) continue;
            it.remove();
            for (IndexShardSnapshotStatus snapshotStatus : entry.getValue().values()) {
                snapshotStatus.abortIfNotCompleted("snapshot has been removed in cluster state, aborting");
            }
        }
    }

    private void startNewSnapshots(SnapshotsInProgress snapshotsInProgress, DiscoveryNode masterNode) {
        String localNodeId = this.clusterService.localNode().getId();
        for (SnapshotsInProgress.Entry entry : snapshotsInProgress.entries()) {
            SnapshotsInProgress.State entryState = entry.state();
            if (entryState == SnapshotsInProgress.State.STARTED) {
                HashMap<ShardId, IndexShardSnapshotStatus> startedShards = null;
                Snapshot snapshot = entry.snapshot();
                Map snapshotShards = this.shardSnapshots.getOrDefault(snapshot, Collections.emptyMap());
                for (ObjectObjectCursor<ShardId, SnapshotsInProgress.ShardSnapshotStatus> objectObjectCursor : entry.shards()) {
                    ShardId shardId = (ShardId)objectObjectCursor.key;
                    SnapshotsInProgress.ShardSnapshotStatus shardSnapshotStatus = (SnapshotsInProgress.ShardSnapshotStatus)objectObjectCursor.value;
                    if (!localNodeId.equals(shardSnapshotStatus.nodeId()) || shardSnapshotStatus.state() != SnapshotsInProgress.State.INIT || snapshotShards.containsKey(shardId)) continue;
                    logger.trace("[{}] - Adding shard to the queue", (Object)shardId);
                    if (startedShards == null) {
                        startedShards = new HashMap<ShardId, IndexShardSnapshotStatus>();
                    }
                    startedShards.put(shardId, IndexShardSnapshotStatus.newInitializing());
                }
                if (startedShards == null || startedShards.isEmpty()) continue;
                this.shardSnapshots.computeIfAbsent(snapshot, s -> new HashMap()).putAll(startedShards);
                this.startNewShards(entry, (Map<ShardId, IndexShardSnapshotStatus>)startedShards, masterNode);
                continue;
            }
            if (entryState != SnapshotsInProgress.State.ABORTED) continue;
            Snapshot snapshot = entry.snapshot();
            Map snapshotShards = this.shardSnapshots.getOrDefault(snapshot, Collections.emptyMap());
            for (ObjectObjectCursor<ShardId, SnapshotsInProgress.ShardSnapshotStatus> objectObjectCursor : entry.shards()) {
                IndexShardSnapshotStatus indexShardSnapshotStatus = (IndexShardSnapshotStatus)snapshotShards.get(objectObjectCursor.key);
                if (indexShardSnapshotStatus != null) {
                    IndexShardSnapshotStatus.Copy lastSnapshotStatus = indexShardSnapshotStatus.abortIfNotCompleted("snapshot has been aborted");
                    IndexShardSnapshotStatus.Stage stage = lastSnapshotStatus.getStage();
                    if (stage == IndexShardSnapshotStatus.Stage.FINALIZE) {
                        logger.debug("[{}] trying to cancel snapshot on shard [{}] that is finalizing, letting it finish", (Object)snapshot, objectObjectCursor.key);
                        continue;
                    }
                    if (stage == IndexShardSnapshotStatus.Stage.DONE) {
                        logger.debug("[{}] trying to cancel snapshot on the shard [{}] that is already done, updating status on the master", (Object)snapshot, objectObjectCursor.key);
                        this.notifySuccessfulSnapshotShard(snapshot, (ShardId)objectObjectCursor.key, masterNode);
                        continue;
                    }
                    if (stage != IndexShardSnapshotStatus.Stage.FAILURE) continue;
                    logger.debug("[{}] trying to cancel snapshot on the shard [{}] that has already failed, updating status on the master", (Object)snapshot, objectObjectCursor.key);
                    this.notifyFailedSnapshotShard(snapshot, (ShardId)objectObjectCursor.key, lastSnapshotStatus.getFailure(), masterNode);
                    continue;
                }
                if (((SnapshotsInProgress.ShardSnapshotStatus)objectObjectCursor.value).state() != SnapshotsInProgress.State.ABORTED) continue;
                this.notifyFailedSnapshotShard(snapshot, (ShardId)objectObjectCursor.key, ((SnapshotsInProgress.ShardSnapshotStatus)objectObjectCursor.value).reason(), masterNode);
            }
        }
    }

    private void startNewShards(SnapshotsInProgress.Entry entry, Map<ShardId, IndexShardSnapshotStatus> startedShards, final DiscoveryNode masterNode) {
        final Snapshot snapshot = entry.snapshot();
        Map indicesMap = entry.indices().stream().collect(Collectors.toMap(IndexId::getName, Function.identity()));
        ExecutorService executor = this.threadPool.executor("snapshot");
        for (final Map.Entry<ShardId, IndexShardSnapshotStatus> shardEntry : startedShards.entrySet()) {
            final ShardId shardId = shardEntry.getKey();
            final IndexId indexId = (IndexId)indicesMap.get(shardId.getIndexName());
            assert (indexId != null);
            executor.execute(new AbstractRunnable(){
                private final SetOnce<Exception> failure = new SetOnce();

                @Override
                public void doRun() {
                    IndexShard indexShard = SnapshotShardsService.this.indicesService.indexServiceSafe(shardId.getIndex()).getShardOrNull(shardId.id());
                    SnapshotShardsService.this.snapshot(indexShard, snapshot, indexId, (IndexShardSnapshotStatus)shardEntry.getValue());
                }

                @Override
                public void onFailure(Exception e) {
                    logger.warn(() -> new ParameterizedMessage("[{}][{}] failed to snapshot shard", (Object)shardId, (Object)snapshot), (Throwable)e);
                    this.failure.set(e);
                }

                @Override
                public void onRejection(Exception e) {
                    this.failure.set(e);
                }

                @Override
                public void onAfter() {
                    Exception exception = this.failure.get();
                    if (exception != null) {
                        SnapshotShardsService.this.notifyFailedSnapshotShard(snapshot, shardId, ExceptionsHelper.detailedMessage(exception), masterNode);
                    } else {
                        SnapshotShardsService.this.notifySuccessfulSnapshotShard(snapshot, shardId, masterNode);
                    }
                }
            });
        }
    }

    private void snapshot(IndexShard indexShard, Snapshot snapshot, IndexId indexId, IndexShardSnapshotStatus snapshotStatus) {
        ShardId shardId = indexShard.shardId();
        if (!indexShard.routingEntry().primary()) {
            throw new IndexShardSnapshotFailedException(shardId, "snapshot should be performed only on primary");
        }
        if (indexShard.routingEntry().relocating()) {
            throw new IndexShardSnapshotFailedException(shardId, "cannot snapshot while relocating");
        }
        IndexShardState indexShardState = indexShard.state();
        if (indexShardState == IndexShardState.CREATED || indexShardState == IndexShardState.RECOVERING) {
            throw new IndexShardSnapshotFailedException(shardId, "shard didn't fully recover yet");
        }
        Repository repository = this.snapshotsService.getRepositoriesService().repository(snapshot.getRepository());
        try (Engine.IndexCommitRef snapshotRef = indexShard.acquireLastIndexCommit(true);){
            repository.snapshotShard(indexShard, indexShard.store(), snapshot.getSnapshotId(), indexId, snapshotRef.getIndexCommit(), snapshotStatus);
            if (logger.isDebugEnabled()) {
                IndexShardSnapshotStatus.Copy lastSnapshotStatus = snapshotStatus.asCopy();
                logger.debug("snapshot ({}) completed to {} with {}", (Object)snapshot, (Object)repository, (Object)lastSnapshotStatus);
            }
        }
        catch (SnapshotFailedEngineException | IndexShardSnapshotFailedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IndexShardSnapshotFailedException(shardId, "Failed to snapshot", e);
        }
    }

    private void syncShardStatsOnNewMaster(ClusterChangedEvent event) {
        SnapshotsInProgress snapshotsInProgress = (SnapshotsInProgress)event.state().custom("snapshots");
        if (snapshotsInProgress == null) {
            return;
        }
        DiscoveryNode masterNode = event.state().nodes().getMasterNode();
        for (SnapshotsInProgress.Entry snapshot : snapshotsInProgress.entries()) {
            Map<ShardId, IndexShardSnapshotStatus> localShards;
            if (snapshot.state() != SnapshotsInProgress.State.STARTED && snapshot.state() != SnapshotsInProgress.State.ABORTED || (localShards = this.currentSnapshotShards(snapshot.snapshot())) == null) continue;
            ImmutableOpenMap<ShardId, SnapshotsInProgress.ShardSnapshotStatus> masterShards = snapshot.shards();
            for (Map.Entry<ShardId, IndexShardSnapshotStatus> localShard : localShards.entrySet()) {
                ShardId shardId = localShard.getKey();
                SnapshotsInProgress.ShardSnapshotStatus masterShard = masterShards.get(shardId);
                if (masterShard == null || masterShard.state().completed()) continue;
                IndexShardSnapshotStatus.Copy indexShardSnapshotStatus = localShard.getValue().asCopy();
                IndexShardSnapshotStatus.Stage stage = indexShardSnapshotStatus.getStage();
                if (stage == IndexShardSnapshotStatus.Stage.DONE) {
                    logger.debug("[{}] new master thinks the shard [{}] is not completed but the shard is done locally, updating status on the master", (Object)snapshot.snapshot(), (Object)shardId);
                    this.notifySuccessfulSnapshotShard(snapshot.snapshot(), shardId, masterNode);
                    continue;
                }
                if (stage != IndexShardSnapshotStatus.Stage.FAILURE) continue;
                logger.debug("[{}] new master thinks the shard [{}] is not completed but the shard failed locally, updating status on master", (Object)snapshot.snapshot(), (Object)shardId);
                this.notifyFailedSnapshotShard(snapshot.snapshot(), shardId, indexShardSnapshotStatus.getFailure(), masterNode);
            }
        }
    }

    private void notifySuccessfulSnapshotShard(Snapshot snapshot, ShardId shardId, DiscoveryNode masterNode) {
        this.sendSnapshotShardUpdate(snapshot, shardId, new SnapshotsInProgress.ShardSnapshotStatus(this.clusterService.localNode().getId(), SnapshotsInProgress.State.SUCCESS), masterNode);
    }

    private void notifyFailedSnapshotShard(Snapshot snapshot, ShardId shardId, String failure, DiscoveryNode masterNode) {
        this.sendSnapshotShardUpdate(snapshot, shardId, new SnapshotsInProgress.ShardSnapshotStatus(this.clusterService.localNode().getId(), SnapshotsInProgress.State.FAILED, failure), masterNode);
    }

    void sendSnapshotShardUpdate(final Snapshot snapshot, ShardId shardId, final SnapshotsInProgress.ShardSnapshotStatus status, DiscoveryNode masterNode) {
        try {
            if (masterNode.getVersion().onOrAfter(Version.V_6_1_0)) {
                this.remoteFailedRequestDeduplicator.executeOnce(new UpdateIndexShardSnapshotStatusRequest(snapshot, shardId, status), new ActionListener<Void>(){

                    @Override
                    public void onResponse(Void aVoid) {
                        logger.trace("[{}] [{}] updated snapshot state", (Object)snapshot, (Object)status);
                    }

                    @Override
                    public void onFailure(Exception e) {
                        logger.warn(() -> new ParameterizedMessage("[{}] [{}] failed to update snapshot state", (Object)snapshot, (Object)status), (Throwable)e);
                    }
                }, (req, reqListener) -> this.transportService.sendRequest(this.transportService.getLocalNode(), UPDATE_SNAPSHOT_STATUS_ACTION_NAME, (TransportRequest)req, new TransportResponseHandler<UpdateIndexShardSnapshotStatusResponse>(){

                    @Override
                    public UpdateIndexShardSnapshotStatusResponse read(StreamInput in) throws IOException {
                        UpdateIndexShardSnapshotStatusResponse response = new UpdateIndexShardSnapshotStatusResponse();
                        response.readFrom(in);
                        return response;
                    }

                    @Override
                    public void handleResponse(UpdateIndexShardSnapshotStatusResponse response) {
                        reqListener.onResponse(null);
                    }

                    @Override
                    public void handleException(TransportException exp) {
                        reqListener.onFailure(exp);
                    }

                    @Override
                    public String executor() {
                        return "same";
                    }
                }));
            } else {
                this.transportService.sendRequest(masterNode, UPDATE_SNAPSHOT_STATUS_ACTION_NAME_V6, new UpdateSnapshotStatusRequestV6(snapshot, shardId, status), EmptyTransportResponseHandler.INSTANCE_SAME);
            }
        }
        catch (Exception e) {
            logger.warn(() -> new ParameterizedMessage("[{}] [{}] failed to update snapshot state", (Object)snapshot, (Object)status), (Throwable)e);
        }
    }

    private void innerUpdateSnapshotState(UpdateIndexShardSnapshotStatusRequest request, final ActionListener<UpdateIndexShardSnapshotStatusResponse> listener) {
        logger.trace("received updated snapshot restore state [{}]", (Object)request);
        this.clusterService.submitStateUpdateTask("update snapshot state", request, ClusterStateTaskConfig.build(Priority.NORMAL), this.snapshotStateExecutor, new ClusterStateTaskListener(){

            @Override
            public void onFailure(String source, Exception e) {
                listener.onFailure(e);
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                listener.onResponse(new UpdateIndexShardSnapshotStatusResponse());
            }
        });
    }

    class UpdateSnapshotStateRequestHandlerV6
    implements TransportRequestHandler<UpdateSnapshotStatusRequestV6> {
        UpdateSnapshotStateRequestHandlerV6() {
        }

        @Override
        public void messageReceived(UpdateSnapshotStatusRequestV6 requestV6, TransportChannel channel) throws Exception {
            UpdateIndexShardSnapshotStatusRequest request = new UpdateIndexShardSnapshotStatusRequest(requestV6.snapshot(), requestV6.shardId(), requestV6.status());
            SnapshotShardsService.this.innerUpdateSnapshotState(request, new ActionListener<UpdateIndexShardSnapshotStatusResponse>(){

                @Override
                public void onResponse(UpdateIndexShardSnapshotStatusResponse updateSnapshotStatusResponse) {
                }

                @Override
                public void onFailure(Exception e) {
                    logger.warn("Failed to update snapshot status", (Throwable)e);
                }
            });
            channel.sendResponse(TransportResponse.Empty.INSTANCE);
        }
    }

    static class UpdateSnapshotStatusRequestV6
    extends TransportRequest {
        private Snapshot snapshot;
        private ShardId shardId;
        private SnapshotsInProgress.ShardSnapshotStatus status;

        UpdateSnapshotStatusRequestV6() {
        }

        UpdateSnapshotStatusRequestV6(Snapshot snapshot, ShardId shardId, SnapshotsInProgress.ShardSnapshotStatus status) {
            this.snapshot = snapshot;
            this.shardId = shardId;
            this.status = status;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.snapshot = new Snapshot(in);
            this.shardId = ShardId.readShardId(in);
            this.status = new SnapshotsInProgress.ShardSnapshotStatus(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.snapshot.writeTo(out);
            this.shardId.writeTo(out);
            this.status.writeTo(out);
        }

        Snapshot snapshot() {
            return this.snapshot;
        }

        ShardId shardId() {
            return this.shardId;
        }

        SnapshotsInProgress.ShardSnapshotStatus status() {
            return this.status;
        }

        public String toString() {
            return this.snapshot + ", shardId [" + this.shardId + "], status [" + (Object)((Object)this.status.state()) + "]";
        }
    }

    private class UpdateSnapshotStatusAction
    extends TransportMasterNodeAction<UpdateIndexShardSnapshotStatusRequest, UpdateIndexShardSnapshotStatusResponse> {
        UpdateSnapshotStatusAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
            super(SnapshotShardsService.this.settings, SnapshotShardsService.UPDATE_SNAPSHOT_STATUS_ACTION_NAME, transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, UpdateIndexShardSnapshotStatusRequest::new);
        }

        @Override
        protected String executor() {
            return "same";
        }

        @Override
        protected UpdateIndexShardSnapshotStatusResponse newResponse() {
            return new UpdateIndexShardSnapshotStatusResponse();
        }

        @Override
        protected void masterOperation(UpdateIndexShardSnapshotStatusRequest request, ClusterState state, ActionListener<UpdateIndexShardSnapshotStatusResponse> listener) {
            SnapshotShardsService.this.innerUpdateSnapshotState(request, listener);
        }

        @Override
        protected ClusterBlockException checkBlock(UpdateIndexShardSnapshotStatusRequest request, ClusterState state) {
            return null;
        }
    }

    static class UpdateIndexShardSnapshotStatusResponse
    extends ActionResponse {
        UpdateIndexShardSnapshotStatusResponse() {
        }
    }

    private class SnapshotStateExecutor
    implements ClusterStateTaskExecutor<UpdateIndexShardSnapshotStatusRequest> {
        private SnapshotStateExecutor() {
        }

        @Override
        public ClusterStateTaskExecutor.ClusterTasksResult<UpdateIndexShardSnapshotStatusRequest> execute(ClusterState currentState, List<UpdateIndexShardSnapshotStatusRequest> tasks) {
            SnapshotsInProgress snapshots = (SnapshotsInProgress)currentState.custom("snapshots");
            if (snapshots != null) {
                int changedCount = 0;
                ArrayList<SnapshotsInProgress.Entry> entries = new ArrayList<SnapshotsInProgress.Entry>();
                for (SnapshotsInProgress.Entry entry : snapshots.entries()) {
                    ImmutableOpenMap.Builder<ShardId, SnapshotsInProgress.ShardSnapshotStatus> shards = ImmutableOpenMap.builder();
                    boolean updated = false;
                    for (UpdateIndexShardSnapshotStatusRequest updateSnapshotState : tasks) {
                        if (!entry.snapshot().equals(updateSnapshotState.snapshot())) continue;
                        logger.trace("[{}] Updating shard [{}] with status [{}]", (Object)updateSnapshotState.snapshot(), (Object)updateSnapshotState.shardId(), (Object)updateSnapshotState.status().state());
                        if (!updated) {
                            shards.putAll(entry.shards());
                            updated = true;
                        }
                        shards.put(updateSnapshotState.shardId(), updateSnapshotState.status());
                        ++changedCount;
                    }
                    if (updated) {
                        if (!SnapshotsInProgress.completed(shards.values())) {
                            entries.add(new SnapshotsInProgress.Entry(entry, shards.build()));
                            continue;
                        }
                        SnapshotsInProgress.Entry updatedEntry = new SnapshotsInProgress.Entry(entry, SnapshotsInProgress.State.SUCCESS, shards.build());
                        entries.add(updatedEntry);
                        continue;
                    }
                    entries.add(entry);
                }
                if (changedCount > 0) {
                    logger.trace("changed cluster state triggered by {} snapshot state updates", (Object)changedCount);
                    return ClusterStateTaskExecutor.ClusterTasksResult.builder().successes(tasks).build(ClusterState.builder(currentState).putCustom("snapshots", new SnapshotsInProgress(Collections.unmodifiableList(entries))).build());
                }
            }
            return ClusterStateTaskExecutor.ClusterTasksResult.builder().successes(tasks).build(currentState);
        }
    }

    public static class UpdateIndexShardSnapshotStatusRequest
    extends MasterNodeRequest<UpdateIndexShardSnapshotStatusRequest> {
        private Snapshot snapshot;
        private ShardId shardId;
        private SnapshotsInProgress.ShardSnapshotStatus status;

        public UpdateIndexShardSnapshotStatusRequest() {
        }

        public UpdateIndexShardSnapshotStatusRequest(Snapshot snapshot, ShardId shardId, SnapshotsInProgress.ShardSnapshotStatus status) {
            this.snapshot = snapshot;
            this.shardId = shardId;
            this.status = status;
            this.masterNodeTimeout = TimeValue.timeValueNanos(Long.MAX_VALUE);
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.snapshot = new Snapshot(in);
            this.shardId = ShardId.readShardId(in);
            this.status = new SnapshotsInProgress.ShardSnapshotStatus(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.snapshot.writeTo(out);
            this.shardId.writeTo(out);
            this.status.writeTo(out);
        }

        public Snapshot snapshot() {
            return this.snapshot;
        }

        public ShardId shardId() {
            return this.shardId;
        }

        public SnapshotsInProgress.ShardSnapshotStatus status() {
            return this.status;
        }

        public String toString() {
            return this.snapshot + ", shardId [" + this.shardId + "], status [" + (Object)((Object)this.status.state()) + "]";
        }
    }
}

