/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.fetch.subphase.highlight;

import java.util.Comparator;
import java.util.List;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.Analyzer;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.document.Field;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.vectorhighlight.FieldFragList;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.CollectionUtil;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.analysis.CustomAnalyzer;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.analysis.NamedAnalyzer;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.analysis.TokenFilterFactory;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.mapper.MappedFieldType;

public final class FragmentBuilderHelper {
    private FragmentBuilderHelper() {
    }

    public static FieldFragList.WeightedFragInfo fixWeightedFragInfo(MappedFieldType fieldType, Field[] values, FieldFragList.WeightedFragInfo fragInfo) {
        assert (fragInfo != null) : "FragInfo must not be null";
        assert (fieldType.name().equals(values[0].name())) : "Expected MappedFieldType for field " + values[0].name();
        if (!fragInfo.getSubInfos().isEmpty() && FragmentBuilderHelper.containsBrokenAnalysis(fieldType.indexAnalyzer())) {
            List<FieldFragList.WeightedFragInfo.SubInfo> subInfos = fragInfo.getSubInfos();
            CollectionUtil.introSort(subInfos, new Comparator<FieldFragList.WeightedFragInfo.SubInfo>(){

                @Override
                public int compare(FieldFragList.WeightedFragInfo.SubInfo o1, FieldFragList.WeightedFragInfo.SubInfo o2) {
                    int startOffset = o1.getTermsOffsets().get(0).getStartOffset();
                    int startOffset2 = o2.getTermsOffsets().get(0).getStartOffset();
                    return FragmentBuilderHelper.compare(startOffset, startOffset2);
                }
            });
            return new FieldFragList.WeightedFragInfo(Math.min(fragInfo.getSubInfos().get(0).getTermsOffsets().get(0).getStartOffset(), fragInfo.getStartOffset()), fragInfo.getEndOffset(), subInfos, fragInfo.getTotalBoost());
        }
        return fragInfo;
    }

    private static int compare(int x, int y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    private static boolean containsBrokenAnalysis(Analyzer analyzer) {
        if (analyzer instanceof NamedAnalyzer) {
            analyzer = ((NamedAnalyzer)analyzer).analyzer();
        }
        if (analyzer instanceof CustomAnalyzer) {
            TokenFilterFactory[] tokenFilters;
            CustomAnalyzer a = (CustomAnalyzer)analyzer;
            for (TokenFilterFactory tokenFilterFactory : tokenFilters = a.tokenFilters()) {
                if (!tokenFilterFactory.breaksFastVectorHighlighter()) continue;
                return true;
            }
        }
        return false;
    }
}

