/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.fetch.subphase;

import java.io.IOException;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.Explanation;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.fetch.FetchPhaseExecutionException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.fetch.FetchSubPhase;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.internal.SearchContext;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.rescore.RescoreContext;

public final class ExplainFetchSubPhase
implements FetchSubPhase {
    @Override
    public void hitExecute(SearchContext context, FetchSubPhase.HitContext hitContext) {
        if (!context.explain()) {
            return;
        }
        try {
            int topLevelDocId = hitContext.hit().docId();
            Explanation explanation = context.searcher().explain(context.query(), topLevelDocId);
            for (RescoreContext rescore : context.rescore()) {
                explanation = rescore.rescorer().explain(topLevelDocId, context.searcher(), rescore, explanation);
            }
            hitContext.hit().explanation(explanation);
        }
        catch (IOException e) {
            throw new FetchPhaseExecutionException(context, "Failed to explain doc [" + hitContext.hit().getType() + "#" + hitContext.hit().getId() + "]", (Throwable)e);
        }
        finally {
            context.clearReleasables(SearchContext.Lifetime.COLLECTION);
        }
    }
}

