/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.metrics.sum;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.lease.Releasables;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.util.BigArrays;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.util.DoubleArray;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.DocValueFormat;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.Aggregator;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.InternalAggregation;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregator;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.metrics.sum.InternalSum;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.support.ValuesSource;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.internal.SearchContext;

public class SumAggregator
extends NumericMetricsAggregator.SingleValue {
    private final ValuesSource.Numeric valuesSource;
    private final DocValueFormat format;
    private DoubleArray sums;
    private DoubleArray compensations;

    SumAggregator(String name, ValuesSource.Numeric valuesSource, DocValueFormat formatter, SearchContext context, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        super(name, context, parent, pipelineAggregators, metaData);
        this.valuesSource = valuesSource;
        this.format = formatter;
        if (valuesSource != null) {
            this.sums = context.bigArrays().newDoubleArray(1L, true);
            this.compensations = context.bigArrays().newDoubleArray(1L, true);
        }
    }

    @Override
    public boolean needsScores() {
        return this.valuesSource != null && this.valuesSource.needsScores();
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        if (this.valuesSource == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final BigArrays bigArrays = this.context.bigArrays();
        final SortedNumericDoubleValues values = this.valuesSource.doubleValues(ctx);
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                SumAggregator.this.sums = bigArrays.grow(SumAggregator.this.sums, bucket + 1L);
                SumAggregator.this.compensations = bigArrays.grow(SumAggregator.this.compensations, bucket + 1L);
                if (values.advanceExact(doc)) {
                    int valuesCount = values.docValueCount();
                    double sum = SumAggregator.this.sums.get(bucket);
                    double compensation = SumAggregator.this.compensations.get(bucket);
                    for (int i = 0; i < valuesCount; ++i) {
                        double value = values.nextValue();
                        if (!Double.isFinite(value)) {
                            sum += value;
                            continue;
                        }
                        if (!Double.isFinite(sum)) continue;
                        double corrected = value - compensation;
                        double newSum = sum + corrected;
                        compensation = newSum - sum - corrected;
                        sum = newSum;
                    }
                    SumAggregator.this.compensations.set(bucket, compensation);
                    SumAggregator.this.sums.set(bucket, sum);
                }
            }
        };
    }

    @Override
    public double metric(long owningBucketOrd) {
        if (this.valuesSource == null || owningBucketOrd >= this.sums.size()) {
            return 0.0;
        }
        return this.sums.get(owningBucketOrd);
    }

    @Override
    public InternalAggregation buildAggregation(long bucket) {
        if (this.valuesSource == null || bucket >= this.sums.size()) {
            return this.buildEmptyAggregation();
        }
        return new InternalSum(this.name, this.sums.get(bucket), this.format, this.pipelineAggregators(), this.metaData());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalSum(this.name, 0.0, this.format, this.pipelineAggregators(), this.metaData());
    }

    @Override
    public void doClose() {
        Releasables.close(this.sums, this.compensations);
    }
}

