/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.metrics.stats.extended;

import java.io.IOException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.collect.Tuple;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ObjectParser;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.metrics.stats.ParsedStats;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.metrics.stats.extended.ExtendedStats;

public class ParsedExtendedStats
extends ParsedStats
implements ExtendedStats {
    protected double sumOfSquares;
    protected double variance;
    protected double stdDeviation;
    protected double stdDeviationBoundUpper;
    protected double stdDeviationBoundLower;
    protected double sum;
    protected double avg;
    private static final ObjectParser<ParsedExtendedStats, Void> PARSER = new ObjectParser(ParsedExtendedStats.class.getSimpleName(), true, ParsedExtendedStats::new);
    private static final ConstructingObjectParser<Tuple<Double, Double>, Void> STD_BOUNDS_PARSER = new ConstructingObjectParser(ParsedExtendedStats.class.getSimpleName() + "_STD_BOUNDS", true, args -> new Tuple<Double, Double>((Double)args[0], (Double)args[1]));
    private static final ConstructingObjectParser<Tuple<String, String>, Void> STD_BOUNDS_AS_STRING_PARSER = new ConstructingObjectParser(ParsedExtendedStats.class.getSimpleName() + "_STD_BOUNDS_AS_STRING", true, args -> new Tuple<String, String>((String)args[0], (String)args[1]));

    @Override
    public String getType() {
        return "extended_stats";
    }

    @Override
    public double getSumOfSquares() {
        return this.sumOfSquares;
    }

    @Override
    public double getVariance() {
        return this.variance;
    }

    @Override
    public double getStdDeviation() {
        return this.stdDeviation;
    }

    private void setStdDeviationBounds(Tuple<Double, Double> bounds) {
        this.stdDeviationBoundLower = bounds.v1();
        this.stdDeviationBoundUpper = bounds.v2();
    }

    @Override
    public double getStdDeviationBound(ExtendedStats.Bounds bound) {
        return bound.equals((Object)ExtendedStats.Bounds.LOWER) ? this.stdDeviationBoundLower : this.stdDeviationBoundUpper;
    }

    @Override
    public String getStdDeviationAsString() {
        return this.valueAsString.getOrDefault("std_deviation_as_string", Double.toString(this.stdDeviation));
    }

    private void setStdDeviationBoundsAsString(Tuple<String, String> boundsAsString) {
        this.valueAsString.put("std_deviation_bounds_as_string_lower", boundsAsString.v1());
        this.valueAsString.put("std_deviation_bounds_as_string_upper", boundsAsString.v2());
    }

    @Override
    public String getStdDeviationBoundAsString(ExtendedStats.Bounds bound) {
        if (bound.equals((Object)ExtendedStats.Bounds.LOWER)) {
            return this.valueAsString.getOrDefault("std_deviation_bounds_as_string_lower", Double.toString(this.stdDeviationBoundLower));
        }
        return this.valueAsString.getOrDefault("std_deviation_bounds_as_string_upper", Double.toString(this.stdDeviationBoundUpper));
    }

    @Override
    public String getSumOfSquaresAsString() {
        return this.valueAsString.getOrDefault("sum_of_squares_as_string", Double.toString(this.sumOfSquares));
    }

    @Override
    public String getVarianceAsString() {
        return this.valueAsString.getOrDefault("variance_as_string", Double.toString(this.variance));
    }

    @Override
    protected XContentBuilder otherStatsToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.count != 0L) {
            builder.field("sum_of_squares", this.sumOfSquares);
            builder.field("variance", this.getVariance());
            builder.field("std_deviation", this.getStdDeviation());
            builder.startObject("std_deviation_bounds");
            builder.field("upper", this.getStdDeviationBound(ExtendedStats.Bounds.UPPER));
            builder.field("lower", this.getStdDeviationBound(ExtendedStats.Bounds.LOWER));
            builder.endObject();
            if (this.valueAsString.containsKey("sum_of_squares_as_string")) {
                builder.field("sum_of_squares_as_string", this.getSumOfSquaresAsString());
                builder.field("variance_as_string", this.getVarianceAsString());
                builder.field("std_deviation_as_string", this.getStdDeviationAsString());
                builder.startObject("std_deviation_bounds_as_string");
                builder.field("upper", this.getStdDeviationBoundAsString(ExtendedStats.Bounds.UPPER));
                builder.field("lower", this.getStdDeviationBoundAsString(ExtendedStats.Bounds.LOWER));
                builder.endObject();
            }
        } else {
            builder.nullField("sum_of_squares");
            builder.nullField("variance");
            builder.nullField("std_deviation");
            builder.startObject("std_deviation_bounds");
            builder.nullField("upper");
            builder.nullField("lower");
            builder.endObject();
        }
        return builder;
    }

    protected static void declareExtendedStatsFields(ObjectParser<? extends ParsedExtendedStats, Void> objectParser) {
        ParsedExtendedStats.declareAggregationFields(objectParser);
        ParsedExtendedStats.declareStatsFields(objectParser);
        objectParser.declareField((agg, value) -> {
            agg.sumOfSquares = value;
        }, (parser, context) -> ParsedExtendedStats.parseDouble(parser, 0.0), new ParseField("sum_of_squares", new String[0]), ObjectParser.ValueType.DOUBLE_OR_NULL);
        objectParser.declareField((agg, value) -> {
            agg.variance = value;
        }, (parser, context) -> ParsedExtendedStats.parseDouble(parser, 0.0), new ParseField("variance", new String[0]), ObjectParser.ValueType.DOUBLE_OR_NULL);
        objectParser.declareField((agg, value) -> {
            agg.stdDeviation = value;
        }, (parser, context) -> ParsedExtendedStats.parseDouble(parser, 0.0), new ParseField("std_deviation", new String[0]), ObjectParser.ValueType.DOUBLE_OR_NULL);
        objectParser.declareObject(ParsedExtendedStats::setStdDeviationBounds, STD_BOUNDS_PARSER, new ParseField("std_deviation_bounds", new String[0]));
        objectParser.declareString((agg, value) -> agg.valueAsString.put("sum_of_squares_as_string", value), new ParseField("sum_of_squares_as_string", new String[0]));
        objectParser.declareString((agg, value) -> agg.valueAsString.put("variance_as_string", value), new ParseField("variance_as_string", new String[0]));
        objectParser.declareString((agg, value) -> agg.valueAsString.put("std_deviation_as_string", value), new ParseField("std_deviation_as_string", new String[0]));
        objectParser.declareObject(ParsedExtendedStats::setStdDeviationBoundsAsString, STD_BOUNDS_AS_STRING_PARSER, new ParseField("std_deviation_bounds_as_string", new String[0]));
    }

    public static ParsedExtendedStats fromXContent(XContentParser parser, String name) {
        ParsedExtendedStats parsedStats = PARSER.apply(parser, null);
        parsedStats.setName(name);
        return parsedStats;
    }

    static {
        STD_BOUNDS_PARSER.declareField(ConstructingObjectParser.constructorArg(), (parser, context) -> ParsedExtendedStats.parseDouble(parser, 0.0), new ParseField("lower", new String[0]), ObjectParser.ValueType.DOUBLE_OR_NULL);
        STD_BOUNDS_PARSER.declareField(ConstructingObjectParser.constructorArg(), (parser, context) -> ParsedExtendedStats.parseDouble(parser, 0.0), new ParseField("upper", new String[0]), ObjectParser.ValueType.DOUBLE_OR_NULL);
        STD_BOUNDS_AS_STRING_PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("lower", new String[0]));
        STD_BOUNDS_AS_STRING_PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("upper", new String[0]));
        ParsedExtendedStats.declareExtendedStatsFields(PARSER);
    }
}

